/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.java.io;

import acm.util.JTFTools;
import java.applet.Applet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;

public class FileInputStream
extends InputStream {
    private InputStream in;

    public FileInputStream(String path) throws FileNotFoundException {
        this.in = this.openInputStream(path);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    private InputStream openInputStream(String path) throws FileNotFoundException {
        try {
            Class<?> fileInputStreamClass = Class.forName("java.io.FileInputStream");
            Class[] types = new Class[]{Class.forName("java.lang.String")};
            Object[] args = new Object[]{path};
            Constructor<?> fileInputStreamConstructor = fileInputStreamClass.getConstructor(types);
            return (InputStream)fileInputStreamConstructor.newInstance(args);
        }
        catch (Exception fileInputStreamClass) {
            URL codeBase;
            InputStream in = this.getClass().getResourceAsStream("/" + path);
            if (in != null) {
                return in;
            }
            Applet applet = JTFTools.getApplet();
            if (applet != null && (codeBase = applet.getCodeBase()) != null) {
                try {
                    URL url = new URL(codeBase, path);
                    return url.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new FileNotFoundException(path);
        }
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] array) throws IOException {
        return this.in.read(array);
    }

    public int read(byte[] array, int offset, int length) throws IOException {
        return this.in.read(array, offset, length);
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

