/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.java.util;

import acm.util.ErrorException;
import acmx.export.java.util.Comparator;
import java.lang.reflect.Method;

public final class Arrays {
    public static final int binarySearch(Object[] array, Object key) {
        return Arrays.binarySearch(array, key, null);
    }

    public static final int binarySearch(Object[] array, Object key, Comparator comparator) {
        int lh = 0;
        int rh = array.length - 1;
        while (lh <= rh) {
            int mid = (lh + rh) / 2;
            int cmp = Arrays.compare(key, array[mid], comparator);
            if (cmp == 0) {
                return mid;
            }
            if (cmp < 0) {
                rh = mid - 1;
                continue;
            }
            lh = mid + 1;
        }
        return -1;
    }

    public static final void sort(Object[] array) {
        Arrays.sort(array, null);
    }

    public static final void sort(Object[] array, Comparator comparator) {
        int lh = 0;
        while (lh < array.length) {
            int rh = lh;
            Object smallestValue = array[rh];
            int i = lh + 1;
            while (i < array.length) {
                int cmp = Arrays.compare(smallestValue, array[i], comparator);
                if (cmp > 0) {
                    rh = i;
                    smallestValue = array[i];
                }
                ++i;
            }
            Object temp = array[lh];
            array[lh] = array[rh];
            array[rh] = temp;
            ++lh;
        }
    }

    public static final Object min(Object[] array) {
        return Arrays.min(array, null);
    }

    public static final Object min(Object[] array, Comparator comparator) {
        Object smallestValue = array[0];
        int i = 1;
        while (i < array.length) {
            int cmp = Arrays.compare(smallestValue, array[i], comparator);
            if (cmp > 0) {
                smallestValue = array[i];
            }
            ++i;
        }
        return smallestValue;
    }

    public static final Object max(Object[] array) {
        return Arrays.max(array, null);
    }

    public static final Object max(Object[] array, Comparator comparator) {
        Object largestValue = array[0];
        int i = 1;
        while (i < array.length) {
            int cmp = Arrays.compare(largestValue, array[i], comparator);
            if (cmp < 0) {
                largestValue = array[i];
            }
            ++i;
        }
        return largestValue;
    }

    public static final void reverse(Object[] array) {
        int lh = 0;
        while (lh < array.length / 2) {
            int rh = array.length - lh - 1;
            Object temp = array[lh];
            array[lh] = array[rh];
            array[rh] = temp;
            ++lh;
        }
    }

    public static final void shuffle(Object[] array) {
        int lh = 0;
        while (lh < array.length) {
            int rh = lh + (int)((double)(array.length - lh) * Math.random());
            Object temp = array[lh];
            array[lh] = array[rh];
            array[rh] = temp;
            ++lh;
        }
    }

    public static final void swap(Object[] array, int lh, int rh) {
        Object temp = array[lh];
        array[lh] = array[rh];
        array[rh] = temp;
    }

    public static final void rotate(Object[] array, int n) {
        throw new ErrorException("Not yet implemented");
    }

    public static final boolean replaceAll(Object[] array, Object oldValue, Object newValue) {
        boolean result = false;
        int i = 0;
        while (i < array.length) {
            if (array[i] == null ? oldValue == null : array[i].equals(oldValue)) {
                array[i] = newValue;
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static int compare(Object x, Object y, Comparator comparator) {
        if (comparator != null) {
            return comparator.compare(x, y);
        }
        if (x instanceof String) {
            return ((String)x).compareTo((String)y);
        }
        try {
            Class<?> baseType = x.getClass();
            Class[] types = new Class[]{Class.forName("java.lang.Object")};
            Object[] args = new Object[]{y};
            Method compareTo = baseType.getMethod("compareTo", types);
            return (Integer)compareTo.invoke(x, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }
}

