/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.java.util;

import acm.util.ErrorException;
import acmx.export.java.util.Comparator;
import acmx.export.java.util.Iterator;
import acmx.export.java.util.SortedSet;
import acmx.export.java.util.TreeSetIterator;
import java.lang.reflect.Method;
import java.util.Vector;

public class TreeSet
implements SortedSet {
    private Comparator comparator;
    private Vector<Object> list = new Vector();

    public TreeSet(Comparator obj) {
        this.comparator = obj;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    public boolean add(Object element) {
        int nElements = this.list.size();
        int index = 0;
        int cmp = -1;
        index = 0;
        while (index < nElements && (cmp = this.compare(element, this.list.elementAt(index))) > 0) {
            ++index;
        }
        if (cmp != 0) {
            this.list.insertElementAt(element, index);
        }
        return cmp != 0;
    }

    public boolean remove(Object value) {
        return this.list.removeElement(value);
    }

    public void clear() {
        this.list.removeAllElements();
    }

    public Object[] toArray() {
        int nElements = this.list.size();
        Object[] array = new Object[nElements];
        int i = 0;
        while (i < nElements) {
            array[i] = this.list.elementAt(i);
            ++i;
        }
        return array;
    }

    public Iterator iterator() {
        return new TreeSetIterator(this.list);
    }

    private int compare(Object x, Object y) {
        if (this.comparator != null) {
            return this.comparator.compare(x, y);
        }
        if (x instanceof String) {
            return ((String)x).compareTo((String)y);
        }
        try {
            Class<?> baseType = x.getClass();
            Class[] types = new Class[]{Class.forName("java.lang.Object")};
            Object[] args = new Object[]{y};
            Method compareTo = baseType.getMethod("compareTo", types);
            return (Integer)compareTo.invoke(x, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }
}

