/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.Icon;
import acmx.export.javax.swing.JApplet;
import acmx.export.javax.swing.JButtonModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

class AWTButton
extends Component
implements JButtonModel,
MouseListener,
MouseMotionListener {
    private static final int MARGIN = 8;
    private static final int ICON_MARGIN = 2;
    private static final int MIN_WIDTH = 48;
    private static final int MIN_HEIGHT = 22;
    private static final Color BGCOLOR = JApplet.BGCOLOR;
    private static final Color ENABLED_BORDER_COLOR = new Color(0x666666);
    private static final Color DISABLED_BORDER_COLOR = new Color(0x999999);
    private static final Color DISABLED_TEXT_COLOR = new Color(0x666666);
    private static final Font FONT = new Font("SansSerif", 1, 10);
    private ArrayList<ActionListener> actionListeners;
    private String label;
    private String actionCommand;
    private Color oldBackground;
    private Icon icon;
    private boolean inside;

    public AWTButton() {
        this.setBackground(BGCOLOR);
        this.setFont(JTFTools.getStandardFont(FONT));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.actionListeners = new ArrayList();
    }

    public void setText(String text) {
        this.label = text;
        this.repaint();
    }

    public String getText() {
        return this.label;
    }

    public void setButtonIcon(Icon awtIcon) {
        this.icon = awtIcon;
        this.repaint();
    }

    public Icon getButtonIcon() {
        return this.icon;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Dimension getPreferredSize() {
        if (this.icon == null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int width = Math.max(fm.stringWidth(this.label) + 16, 48);
            int height = Math.max(fm.getHeight() + 2, 22);
            return new Dimension(width, height);
        }
        int width = this.icon.getIconWidth() + 4;
        int height = this.icon.getIconHeight() + 4;
        return new Dimension(width, height);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.isEnabled() ? ENABLED_BORDER_COLOR : DISABLED_BORDER_COLOR);
        g.drawRect(0, 0, size.width - 2, size.height - 2);
        g.setColor(Color.WHITE);
        g.drawRect(1, 1, size.width - 2, size.height - 2);
        g.setColor(this.getBackground());
        g.drawLine(1, size.height - 1, 1, size.height - 1);
        g.drawLine(size.width - 1, 1, size.width - 1, 1);
        g.setColor(this.isEnabled() ? this.getForeground() : DISABLED_TEXT_COLOR);
        if (this.icon == null) {
            FontMetrics fm = g.getFontMetrics();
            int x = (size.width - fm.stringWidth(this.label)) / 2;
            int y = (size.height + fm.getAscent()) / 2 - 2;
            g.drawString(this.label, x, y);
        } else {
            this.icon.paintIcon(this, g, 2, 2);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.oldBackground = this.getBackground();
        this.setBackground(this.oldBackground.darker());
        this.repaint();
        this.inside = true;
    }

    public void mouseReleased(MouseEvent e) {
        this.setBackground(this.oldBackground);
        this.repaint();
        if (this.contains(e.getPoint())) {
            String command = this.actionCommand;
            if (command == null) {
                command = this.label;
            }
            this.fireActionListeners(new ActionEvent(e.getSource(), 1001, command, e.getModifiers()));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.inside != this.contains(e.getPoint())) {
            boolean bl = this.inside = !this.inside;
            if (this.inside) {
                this.mousePressed(e);
            } else {
                this.mouseReleased(e);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

