/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.Platform;
import acmx.export.javax.swing.AWTFileChooser;
import acmx.export.javax.swing.JDialog;
import acmx.export.javax.swing.JFileChooserModel;
import java.awt.Component;
import java.io.File;

public class JFileChooser {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private JFileChooserModel model;

    public JFileChooser() {
        if (Platform.compareVersion("1.2") >= 0) {
            try {
                this.model = (JFileChooserModel)Class.forName("SwingFileChooser").newInstance();
            }
            catch (Exception ex) {
                this.model = new AWTFileChooser();
            }
        } else {
            this.model = new AWTFileChooser();
        }
    }

    public JFileChooser(String path) {
        this();
        this.setCurrentDirectory(new File(path));
    }

    public JFileChooser(File dir) {
        this();
        this.setCurrentDirectory(dir);
    }

    public String getDialogTitle() {
        return this.model.getDialogTitle();
    }

    public void setDialogTitle(String title) {
        this.model.setDialogTitle(title);
    }

    public File getSelectedFile() {
        return this.model.getSelectedFile();
    }

    public void setSelectedFile(File file) {
        this.model.setSelectedFile(file);
    }

    public void setFileSelectionMode(int mode) {
        this.model.setFileSelectionMode(mode);
    }

    public File getCurrentDirectory() {
        return this.model.getCurrentDirectory();
    }

    public void setCurrentDirectory(File dir) {
        this.model.setCurrentDirectory(dir);
    }

    public int showOpenDialog(Component parent) {
        return this.model.showOpenDialog(parent);
    }

    public int showSaveDialog(Component parent) {
        return this.model.showSaveDialog(parent);
    }

    protected JDialog createDialog(Component parent) {
        if (parent != parent) {
            // empty if block
        }
        return null;
    }
}

