/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.gui.TableLayout;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acmx.export.javax.swing.JPanel;
import acmx.export.javax.swing.JScrollPaneBorder;
import acmx.export.javax.swing.JTextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class JScrollPane
extends Container
implements ComponentListener {
    public static final int VERTICAL_SCROLLBAR_ALWAYS = 22;
    public static final int HORIZONTAL_SCROLLBAR_ALWAYS = 32;
    private Image offscreen;
    private Scrollbar vScrollbar;
    private Scrollbar hScrollbar;
    private JPanel viewPanel;

    public JScrollPane(int vPolicy, int hPolicy) {
        if (vPolicy != 22 || hPolicy != 32) {
            throw new ErrorException("Unsupported JScrollPane policy");
        }
        this.setLayout(new TableLayout(3, 3));
        this.hScrollbar = new Scrollbar(0, 0, 100, 0, 100);
        this.vScrollbar = new Scrollbar(1, 0, 100, 0, 100);
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new BorderLayout());
        this.add((Component)new JScrollPaneBorder(), "gridheight=2 width=1");
        this.add((Component)new JScrollPaneBorder(), "height=1");
        this.add((Component)this.vScrollbar, "gridheight=2 fill=VERTICAL");
        this.add((Component)this.viewPanel, "weightx=1 weighty=1 fill=BOTH");
        this.add((Component)this.hScrollbar, "gridwidth=2 fill=HORIZONTAL");
        this.addComponentListener(this);
    }

    public void setViewportView(Component c) {
        this.viewPanel.add(c, "Center");
        if (c instanceof JTextPane) {
            JTextPane textPane = (JTextPane)c;
            textPane.setHScrollbar(this.hScrollbar);
            textPane.setVScrollbar(this.vScrollbar);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            super.paint(g);
        } else {
            Graphics osg = this.offscreen.getGraphics();
            osg.setColor(g.getColor());
            osg.setFont(g.getFont());
            super.paint(osg);
            g.drawImage(this.offscreen, 0, 0, this);
        }
    }

    public final void componentResized(ComponentEvent e) {
        Dimension size = this.getSize();
        int width = Math.max(1, size.width);
        int height = Math.max(1, size.height);
        Frame frame = JTFTools.getEnclosingFrame(this);
        this.offscreen = frame.createImage(width, height);
        this.repaint();
    }

    public final void componentHidden(ComponentEvent e) {
    }

    public final void componentMoved(ComponentEvent e) {
    }

    public final void componentShown(ComponentEvent e) {
    }
}

