/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acmx.export.javax.swing.AWTTextField;
import acmx.export.javax.swing.JTextFieldModel;
import acmx.export.javax.swing.SwingInteractor;
import acmx.export.javax.swing.TextFieldActionListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;

public class JTextField
extends SwingInteractor {
    public static final int CENTER = 0;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    private ArrayList<ActionListener> actionListeners;
    private JTextFieldModel model = new AWTTextField();
    private TextFieldActionListener textFieldListener;
    private int nColumns;

    public JTextField() {
        this("", 0);
    }

    public JTextField(int columns) {
        this("", columns);
    }

    public JTextField(String text) {
        this(text, text.length());
    }

    public JTextField(String text, int columns) {
        this.setContents((Component)((Object)this.model));
        this.setText(text);
        this.setColumns(columns);
        this.setHorizontalAlignment(2);
        this.actionListeners = new ArrayList();
        this.textFieldListener = new TextFieldActionListener(this);
        this.model.addActionListener(this.textFieldListener);
    }

    public void setText(String text) {
        this.model.setText(text);
    }

    public String getText() {
        return this.model.getText();
    }

    public void selectAll() {
        this.model.selectAll();
    }

    public void requestFocus() {
        this.model.requestFocus();
    }

    public void setActionCommand(String command) {
        this.model.setActionCommand(command);
    }

    public void setHorizontalAlignment(int align) {
        this.model.setHorizontalAlignment(align);
    }

    public int getHorizontalAlignment() {
        return this.model.getHorizontalAlignment();
    }

    public void setColumns(int columns) {
        this.nColumns = columns;
        this.model.setColumns(columns);
    }

    public int getColumns() {
        return this.nColumns;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    protected void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    public ActionListener[] getActionListeners() {
        int nListeners = this.actionListeners.size();
        ActionListener[] array = new ActionListener[nListeners];
        int i = 0;
        while (i < nListeners) {
            array[i] = this.actionListeners.get(i);
            ++i;
        }
        return array;
    }

    public void addKeyListener(KeyListener listener) {
        this.model.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.model.removeKeyListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.model.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.model.removeFocusListener(listener);
    }

    public void setEditable(boolean editable) {
        this.model.setEditable(editable);
    }

    public boolean isEditable() {
        return this.model.isEditable();
    }
}

