package pmf.imi.booking;

import java.util.ArrayList;
import java.util.List;

public class BookingPage {


    private String fullName;
    private int nights;
    private AccommodationType accommodationType;
    List<Amenity> amenities = new ArrayList<Amenity>();

    private boolean isValidFullName(String name) {
        if (name == null) return false;
        if (name.length() < 2 || name.length() > 18) return false;
        if (name.startsWith(" ") || name.endsWith(" ")) return false;
        if (!name.contains(" ")) return false;
        return name.matches("[А-Яа-яA-Za-z ]+");
    }

    public BookingResult reserve() {

        if (!isValidFullName(fullName)) {
            return new BookingResult("Uneto ime nije u ispravnom formatu", "");
        }

        // Validacija broja noćenja
        if (nights < 1 || nights > 11) {
            return new BookingResult("Broj nocenja mora biti u opsegu 1-12", "");
        }

        // Ako je sve validno
        String statusMessage = "Uspesno rezervisan smestaj u " +
                (accommodationType == AccommodationType.APARTMENT ? "apartmanu." : "sobi.");

        String amenitiesMessage = "";
        if (amenities != null && !amenities.isEmpty()) {
            List<String> amenityNames = new ArrayList<>();
            for (Amenity a : amenities) {
                if (a == Amenity.PARKING) {
                    amenityNames.add("Parking");
                } else if (a == Amenity.SPA) {
                    amenityNames.add("Spa");
                }
            }
            amenitiesMessage = String.join(", ", amenityNames) + ".";
        }

        return new BookingResult(statusMessage, amenitiesMessage);
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public int getNights() {
        return nights;
    }

    public void setNights(int nights) {
        this.nights = nights;
    }

    public AccommodationType getAccommodationType() {
        return accommodationType;
    }

    public void setAccommodationType(AccommodationType accommodationType) {
        this.accommodationType = accommodationType;
    }

    public void addAmenity(Amenity amenity){
        amenities.add(amenity);
    }
}