<?php


class Db
{
    const host = "localhost"; // podesiti ogvarajucu putanju i port
    const dbname = "cars_popravni";
    const user = "root";
    const pass = "";
    
    private $dbh;
    
    function __construct() 
    {
        try
        {
            $string = "mysql:host=".self::host.";dbname=".self::dbname;
            $this->dbh = new PDO($string, self::user, self::pass);
        } catch (Exception $ex) 
        {
            echo "greska prilikom konekcije sa bazom!";
            die();
        }
    }
    function __destruct() 
    {
        $this->dbh = null;
    }
    function proveriKorisnika($user, $pass)
    {
        $pass = sha1($pass);
        $sql = "select * from korisnik where username = '$user' and password = '$pass'";
        $upit = $this->dbh->query($sql);
        return $upit->fetch(PDO::FETCH_ASSOC);
    }



    public function IzdvojeniAutomobili()
    {
        $sql = "SELECT * FROM automobil a JOIN proizvodjac p ON a.proizvodjac_id = p.id JOIN tip t ON a.tip_id = t.id WHERE a.izdvojen = 1";
        $upit = $this->dbh->query($sql);
        $automobili = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $automobili;
    }

    public function SpisakAutomobila($model, $proizvodjacIds, $tipIds, $cena_do, $godina_od)
    {
        // Build base query and parameters for prepared statement
        $sql = "SELECT * FROM automobil a JOIN proizvodjac p ON a.proizvodjac_id = p.id JOIN tip t ON a.tip_id = t.id WHERE 1";
        $params = array();

        if ($model != "") {
            $sql .= " AND a.model LIKE :model";
            $params[':model'] = "%" . $model . "%";
        }

        // filter by proizvodjac ids (array expected)
        if (!empty($proizvodjacIds) && is_array($proizvodjacIds)) {
            // ensure numeric ids
            $placeholders = array();
            foreach ($proizvodjacIds as $i => $id) {
                $key = ":prov_" . $i;
                $placeholders[] = $key;
                $params[$key] = (int)$id;
            }
            if (count($placeholders) > 0) {
                $sql .= " AND p.id IN (" . implode(',', $placeholders) . ")";
            }
        }

        // filter by tip ids (array expected)
        if (!empty($tipIds) && is_array($tipIds)) {
            $placeholders = array();
            foreach ($tipIds as $i => $id) {
                $key = ":tip_" . $i;
                $placeholders[] = $key;
                $params[$key] = (int)$id;
            }
            if (count($placeholders) > 0) {
                $sql .= " AND t.id IN (" . implode(',', $placeholders) . ")";
            }
        }

        if ($cena_do != 0) {
            $sql .= " AND a.cena <= :cena_do";
            $params[':cena_do'] = (int)$cena_do;
        }

        if ($godina_od != 0) {
            $sql .= " AND a.godina_proizvodnje >= :godina_od";
            $params[':godina_od'] = (int)$godina_od;
        }

        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $automobili = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $automobili;
    }

    public function Proizvodjaci()
    {
        $sql = "SELECT * FROM proizvodjac";
        $upit = $this->dbh->query($sql);
        $proizvodjaci = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $proizvodjaci;
        
    }

    public function TipoviKaroserije(){
        $sql = "SELECT * FROM tip";
        $upit = $this->dbh->query($sql);
        $tipovi = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $tipovi;
    }

    public function AutomobilById($idAutomobila)
    {
        $sql = "SELECT * FROM automobil a JOIN proizvodjac p ON a.proizvodjac_id = p.id JOIN tip t ON a.tip_id = t.id WHERE a.automobil_id = ".$idAutomobila;
        $upit = $this->dbh->query($sql);
        return $upit->fetch(PDO::FETCH_ASSOC);
    }

    // dodati sort po ceni



}

?>