package org.imi;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.Select;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

import org.openqa.selenium.support.ui.WebDriverWait;
import org.openqa.selenium.support.ui.ExpectedConditions;
import java.time.Duration;
import org.openqa.selenium.SearchContext;

import java.util.List;
import java.util.Set;
import static org.testng.Assert.*;

public class ShortSeleniumTest {
    WebDriver driver;

    @BeforeSuite
    public void beforeSuite(){
        // WebDriverManager.edgedriver().setup();
        WebDriverManager.chromedriver().setup();
    }

    @BeforeMethod
    public void beforeMethod(){
        // System.setProperty("webdriver.chrome.driver", "C:\\Users\\djordje\\Desktop\\chromedriver.exe");
        // WebDriver driver = new ChromeDriver();

        // System.setProperty("webdriver.gecko.driver", "C:\\Users\\djordje\\Desktop\\geckodriver.exe");
        // WebDriver driver = new FirefoxDriver();

        // driver = new EdgeDriver();
        driver = new ChromeDriver();
        driver.manage().window().maximize();
    }

    @AfterMethod
    public void afterTestMethod(){
//        driver.quit();
    }

    @Test
    public void seleniumTest1() throws InterruptedException {
        // static dropdown
        driver.get("https://www.esky.rs/");
        Thread.sleep(5000L);
        driver.manage().window().maximize();

        // close popup - Nece da radi ovako!
        // Pogledajte PageSource (ne postoji ovaj element u DOM-u, iako ga InspectElement)
        // driver.findElement(By.xpath("//button[@data-testid='uc-accept-all-button']")).click();

        // Shadow DOM
        By shadowDomContainerBy = By.id("usercentrics-root");
        By klasaBy = By.xpath("//select[@id='serviceClass']/following-sibling::*/div");
        WebDriverWait wdw = new WebDriverWait(driver, Duration.ofSeconds(15));
        wdw.until(ExpectedConditions.presenceOfElementLocated(shadowDomContainerBy));

        WebElement shadowDomContainer = driver.findElement(shadowDomContainerBy);
        assertNotNull(shadowDomContainer);

        SearchContext shadowRoot = shadowDomContainer.getShadowRoot();
        shadowRoot.findElement(By.cssSelector("button[data-testid='uc-accept-all-button']")).click();

        // Izabrati da broj odraslih bude 5.
        driver.findElement(By.xpath("//div[@data-content-id='pax-counter']")).click();

        for(int i=1; i<5; i++)
        {
            driver.findElement(By.xpath("//div[@class='pax adult '] //a[@data-operator='plus']")).click();
        }
        driver.findElement(By.cssSelector(".btn.small.function.ghost.close-pax-counter")).click();

        // Assert
        assertEquals(driver.findElement(By.xpath("//span[@class='pax-number adult-pax-amount']")).getText(), "5");
    }

    // I verzija resenja
    @Test
    public void seleniumTest2() throws InterruptedException {
        // static dropdown
        driver.get("https://www.polovniautomobili.com/");
//      close popups -- Nekada ih ima, nekada ne (kod za popups mozda ne radi, zavisi od UI implementacije)
//        first popup
//        driver.findElement(By.cssSelector(".fc-button.fc-cta-consent.fc-primary-button")).click();
//        driver.findElement(By.xpath("//button[@class='fc-button fc-cta-consent fc-primary-button']")).click();

//        second popup
//        driver.findElement(By.xpath("//div[@class='_ado-responsiveFooterBillboard-hover']")).click();
//        third popup
//        driver.findElement(By.xpath("//div[contains(@class, 'uk-width-medium-1-10') and contains(@class, 'uk-width-1-1')]")).click();

        driver.manage().window().maximize();
//        Select s = new Select(driver.findElement(By.xpath("#brand")));

//        THE FIRST SOLUTION *****
        driver.findElement(By.xpath("//div[contains(@class, 'SumoSelect') and contains(@class, 'sumo_brand')]")).click();
//        driver.findElement(By.xpath(
//                "//div[@class='SumoSelect sumo_brand']/p[@class='CaptionCont SelectBox search']/span")).click();

        List<WebElement> div_list = driver.findElements(By.xpath("//div[@class='optWrapper']"));
        WebElement div_brand = div_list.getFirst(); // get(0);

//        get all li elements inside selected div
        List<WebElement> li_list = div_brand.findElements(By.xpath("//ul/li"));

//        search list for a specific text
        for (WebElement option : li_list) {
            if (option.getText().equalsIgnoreCase("Opel")) {
                option.click();
                break;
            }
        }
    }

    // II verzija resenja
    @Test
    public void seleniumTest3() throws InterruptedException {

        driver.get("https://www.polovniautomobili.com/");
//      close popups
//        first popup
//        driver.findElement(By.cssSelector(".fc-button.fc-cta-consent.fc-primary-button")).click();
//        driver.findElement(By.xpath("//button[@class='fc-button fc-cta-consent fc-primary-button']")).click();

//        second popup
//        driver.findElement(By.xpath("//div[@class='_ado-responsiveFooterBillboard-hover']")).click();
//        third popup
//        driver.findElement(By.xpath("//div[contains(@class, 'uk-width-medium-1-10') and contains(@class, 'uk-width-1-1')]")).click();

        driver.manage().window().maximize();

//        get car value
        driver.findElement(By.xpath("//div[contains(@class, 'SumoSelect') and contains(@class, 'sumo_brand')]")).click();

        List<WebElement> labels = driver.findElements(By.cssSelector("div[class='optWrapper'] ul li"));

        for(WebElement option :labels){
            if(option.getText().equalsIgnoreCase("Opel")){
                option.click();
                break;
            }
        }
    }

    @Test
    public void seleniumTest4() throws InterruptedException {
        // Solution provided by Srđan Todorović
        driver.manage().window().maximize();
        driver.get("https://www.polovniautomobili.com");

        // ugasi pop-ove
//        driver.findElement(By.xpath("//button[@class='fc-button fc-cta-consent fc-primary-button']")).click();
//        driver.findElement(By.xpath("//div[@class='_ado-responsiveFooterBillboard-hover']")).click();

        // izbor marke
        driver.findElement(By.xpath(
                "//div[@class='SumoSelect sumo_brand']/p[@class='CaptionCont SelectBox search']/span")).click();

        driver.findElement(By.xpath(
                "//div[@class='SumoSelect sumo_brand open']//input")).sendKeys("Opel");

        driver.findElement(By.xpath(
                        "//div[@class='SumoSelect sumo_brand open']//ul[@class='options']/li[@class='opt']"))
                .click();

        // cekiraj garaniciju
        driver.findElement(By.xpath("//input[@id='warranty']")).click();

        // unos max cene
        driver.findElement(By.xpath("//input[@id='price_to']")).sendKeys("2000");

        // pretraga
        driver.findElement(By.xpath("//button[@class='js-search-buttons paOrangeButtonPrimary uk-width-1-1 uk-margin-small-bottom search-image']")).click();

//        driver.findElement(By.xpath("//div[@class='_ado-responsiveFooterBillboard-hover']")).click();

        // uzmi jedan element
        WebElement oglas = driver.findElements(By.xpath("//article")).get(1);
        System.out.println(oglas.getText());
        oglas.findElement(By.xpath("//a[@class='ga-title']")).click();

        // driver.quit();
    }


}
