package pmf.imi.clinic;

public class AppointmentService {

    /**
     * @param fullName full name of the patient
     * @param medicalRecordNumber medical record number (11 digits)
     * @param daysFromToday number of days from today when appointment is scheduled
     * @param appointmentType "GENERAL" or "SPECIALIST"
     * @return result message
     */
    public String scheduleAppointment(
            String fullName,
            String medicalRecordNumber,
            int daysFromToday,
            String appointmentType) {

        if (!isFullNameValid(fullName)) {
            return "Neispravno ime i prezime";
        }

        if (!isMedicalRecordNumberValid(medicalRecordNumber)) {
            return "Broj knjižice nije validan";
        }

        if (!isAppointmentDateValid(daysFromToday)) {
            return "Datum pregleda nije validan";
        }

        if (!isAppointmentTypeValid(appointmentType)) {
            return "Tip pregleda nije validan";
        }

        return "Termin uspešno zakazan za "
                + (appointmentType.equals("GENERAL") ? "Opšti" : "Specijalistički")
                + " pregled";
    }

    /* =======================
       Validation helper methods
       ======================= */

    private boolean isFullNameValid(String fullName) {
        if (fullName == null) {
            return false;
        }

        if (fullName.length() < 3 || fullName.length() > 30) {
            return false;
        }

        return fullName.matches("[A-Za-z ]+");
    }

    private boolean isMedicalRecordNumberValid(String number) {
        if (number == null) {
            return false;
        }

        return number.matches("\\d{11}");
    }

    private boolean isAppointmentDateValid(int daysFromToday) {
        return daysFromToday >= 1 && daysFromToday <= 30;
    }

    private boolean isAppointmentTypeValid(String type) {
        return "GENERAL".equals(type) || "SPECIALIST".equals(type);
    }
}
