<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shopping Cart - Jewelry Store</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px 0;
            margin-bottom: 20px;
        }
        .cart-item {
            border: 1px solid #dee2e6;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .cart-item-image {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 8px;
        }
        .quantity-input {
            width: 80px;
            text-align: center;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }
        .price-display {
            font-size: 1.2rem;
            font-weight: bold;
            color: #28a745;
        }
        .total-price {
            font-size: 1.5rem;
            font-weight: bold;
            color: #28a745;
        }
        .btn-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 10px 25px;
            color: white;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .btn-outline-custom {
            border: 2px solid #667eea;
            color: #667eea;
            background: transparent;
            border-radius: 25px;
            padding: 10px 25px;
            transition: all 0.3s ease;
        }
        .btn-outline-custom:hover {
            background: #667eea;
            color: white;
            transform: translateY(-2px);
        }
        .cart-icon {
            position: relative;
        }
        .cart-count {
            position: absolute;
            top: -10px;
            right: -10px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 0.8rem;
            min-width: 20px;
            text-align: center;
        }
        .main-content {
            flex: 1;
        }
        .footer {
            margin-top: auto;
        }
        .navbar {
            padding: 0.5rem 0;
        }
        .empty-cart {
            text-align: center;
            padding: 60px 20px;
        }
        .empty-cart i {
            font-size: 4rem;
            color: #6c757d;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php
    session_start();

    // Handle cart updates
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        if (isset($_POST['update_cart'])) {
            foreach ($_POST['quantity'] as $item_id => $quantity) {
                $quantity = (int)$quantity;
                if ($quantity <= 0) {
                    unset($_SESSION['cart'][$item_id]);
                } else {
                    $_SESSION['cart'][$item_id] = $quantity;
                }
            }
        } elseif (isset($_POST['remove_item'])) {
            $item_id = $_POST['remove_item'];
            unset($_SESSION['cart'][$item_id]);
        } elseif (isset($_POST['clear_cart'])) {
            $_SESSION['cart'] = [];
        }
    }

    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $qty) {
            $cart_count += $qty;
        }
    }

    $items = json_decode(file_get_contents('data/items.json'), true);
    $cart_items = [];
    $total = 0;

    if (isset($_SESSION['cart']) && !empty($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $item_id => $quantity) {
            foreach ($items as $item) {
                if ($item['id'] == $item_id) {
                    $subtotal = $item['price'] * $quantity;
                    $total += $subtotal;
                    $cart_items[] = [
                        'item' => $item,
                        'quantity' => $quantity,
                        'subtotal' => $subtotal
                    ];
                    break;
                }
            }
        }
    }
    ?>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-gem me-2"></i>Jewelry Store
            </a>
            <div class="navbar-nav ms-auto">
                <div class="nav-item cart-icon">
                    <a class="nav-link" href="cart.php">
                        <i class="fas fa-shopping-cart fa-lg"></i>
                        <span class="cart-count"><?php echo $cart_count; ?></span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <div class="main-content">
        <!-- Hero Section -->
        <section class="hero-section">
            <div class="container text-center">
                <h1 class="display-5 mb-1">Shopping Cart</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center bg-transparent p-0 m-0">
                        <li class="breadcrumb-item"><a href="index.php" class="text-white">Home</a></li>
                        <li class="breadcrumb-item active text-light" aria-current="page">Cart</li>
                    </ol>
                </nav>
            </div>
        </section>

        <div class="container">
            <?php if (empty($cart_items)): ?>
                <!-- Empty Cart -->
                <div class="empty-cart">
                    <i class="fas fa-shopping-cart"></i>
                    <h3 class="text-muted mb-3">Your cart is empty</h3>
                    <p class="text-muted mb-4">Add some beautiful jewelry to your cart and come back!</p>
                    <a href="index.php" class="btn btn-custom">
                        <i class="fas fa-arrow-left me-2"></i>Continue Shopping
                    </a>
                </div>
            <?php else: ?>
                <!-- Cart Items -->
                <form method="POST">
                    <div class="row">
                        <div class="col-lg-8">
                            <h4 class="mb-4">Cart Items (<?php echo count($cart_items); ?>)</h4>

                            <?php foreach ($cart_items as $cart_item): ?>
                                <div class="cart-item">
                                    <div class="row align-items-center">
                                        <div class="col-md-2">
                                            <img src="<?php echo $cart_item['item']['images'][0]; ?>" alt="<?php echo $cart_item['item']['name']; ?>" class="cart-item-image">
                                        </div>
                                        <div class="col-md-4">
                                            <h5 class="mb-1"><?php echo $cart_item['item']['name']; ?></h5>
                                            <p class="text-muted small mb-0"><?php echo $cart_item['item']['category']; ?></p>
                                        </div>
                                        <div class="col-md-2">
                                            <span class="price-display">$<?php echo number_format($cart_item['item']['price'], 2); ?></span>
                                        </div>
                                        <div class="col-md-2">
                                            <input type="number" name="quantity[<?php echo $cart_item['item']['id']; ?>]" value="<?php echo $cart_item['quantity']; ?>" min="1" max="99" class="form-control quantity-input">
                                        </div>
                                        <div class="col-md-2">
                                            <div class="d-flex flex-column gap-2">
                                                <span class="price-display">$<?php echo number_format($cart_item['subtotal'], 2); ?></span>
                                                <button type="submit" name="remove_item" value="<?php echo $cart_item['item']['id']; ?>" class="btn btn-outline-danger btn-sm">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                            <div class="d-flex gap-2 mt-3">
                                <button type="submit" name="update_cart" class="btn btn-outline-custom">
                                    <i class="fas fa-sync me-1"></i>Update Cart
                                </button>
                                <button type="submit" name="clear_cart" class="btn btn-outline-danger" onclick="return confirm('Are you sure you want to clear your cart?')">
                                    <i class="fas fa-trash me-1"></i>Clear Cart
                                </button>
                            </div>
                        </div>

                        <!-- Cart Summary -->
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">Order Summary</h5>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-3">
                                        <span>Subtotal (<?php echo $cart_count; ?> items)</span>
                                        <span>$<?php echo number_format($total, 2); ?></span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-3">
                                        <span>Shipping</span>
                                        <span class="text-success">Free</span>
                                    </div>
                                    <hr>
                                    <div class="d-flex justify-content-between mb-4">
                                        <span class="total-price">Total</span>
                                        <span class="total-price">$<?php echo number_format($total, 2); ?></span>
                                    </div>
                                    <a href="checkout.php" class="btn btn-custom w-100 mb-3">
                                        <i class="fas fa-credit-card me-2"></i>Proceed to Checkout
                                    </a>
                                    <a href="index.php" class="btn btn-outline-custom w-100">
                                        <i class="fas fa-arrow-left me-2"></i>Continue Shopping
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-2 footer">
        <div class="container text-center">
            <p class="mb-0">&copy; 2026 Jewelry Store. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>