<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - Jewelry Store</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px 0;
            margin-bottom: 20px;
        }
        .checkout-form {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .btn-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 10px 25px;
            color: white;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .order-summary {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
        }
        .main-content {
            flex: 1;
        }
        .footer {
            margin-top: auto;
        }
        .navbar {
            padding: 0.5rem 0;
        }
        .cart-icon {
            position: relative;
        }
        .cart-count {
            position: absolute;
            top: -10px;
            right: -10px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 0.8rem;
            min-width: 20px;
            text-align: center;
        }
    </style>
</head>
<body>
    <?php
    session_start();

    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $qty) {
            $cart_count += $qty;
        }
    }

    $items = json_decode(file_get_contents('data/items.json'), true);
    $cart_items = [];
    $total = 0;

    if (isset($_SESSION['cart']) && !empty($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $item_id => $quantity) {
            foreach ($items as $item) {
                if ($item['id'] == $item_id) {
                    $subtotal = $item['price'] * $quantity;
                    $total += $subtotal;
                    $cart_items[] = [
                        'item' => $item,
                        'quantity' => $quantity,
                        'subtotal' => $subtotal
                    ];
                    break;
                }
            }
        }
    }

    $order_processed = false;
    $order_details = [];

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($cart_items)) {
        $first_name = htmlspecialchars($_POST['first_name']);
        $last_name = htmlspecialchars($_POST['last_name']);
        $address = htmlspecialchars($_POST['address']);
        $payment_method = htmlspecialchars($_POST['payment_method']);

        $order_details = [
            'first_name' => $first_name,
            'last_name' => $last_name,
            'address' => $address,
            'payment_method' => $payment_method,
            'total' => $total,
            'items' => $cart_items
        ];

        // Clear the cart
        $_SESSION['cart'] = [];
        $cart_count = 0;
        $cart_items = [];
        $total = 0;
        $order_processed = true;
    }
    ?>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-gem me-2"></i>Jewelry Store
            </a>
            <div class="navbar-nav ms-auto">
                <div class="nav-item cart-icon">
                    <a class="nav-link" href="cart.php">
                        <i class="fas fa-shopping-cart fa-lg"></i>
                        <span class="cart-count"><?php echo $cart_count; ?></span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <div class="main-content">
        <!-- Hero Section -->
        <section class="hero-section">
            <div class="container text-center">
                <h1 class="display-5 mb-1">Checkout</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center bg-transparent p-0 m-0">
                        <li class="breadcrumb-item"><a href="index.php" class="text-white">Home</a></li>
                        <li class="breadcrumb-item"><a href="cart.php" class="text-white">Cart</a></li>
                        <li class="breadcrumb-item active text-light" aria-current="page">Checkout</li>
                    </ol>
                </nav>
            </div>
        </section>

        <div class="container">
            <?php if ($order_processed): ?>
                <!-- Order Confirmation -->
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="text-center mb-4">
                            <i class="fas fa-check-circle text-success" style="font-size: 4rem;"></i>
                            <h2 class="mt-3">Order Confirmed!</h2>
                            <p class="text-muted">Thank you for your purchase. Your order has been processed successfully.</p>
                        </div>
                        <div class="card">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0">Order Summary</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Shipping Information</h6>
                                        <p><strong>Name:</strong> <?php echo $order_details['first_name'] . ' ' . $order_details['last_name']; ?></p>
                                        <p><strong>Address:</strong> <?php echo nl2br($order_details['address']); ?></p>
                                        <p><strong>Payment Method:</strong> <?php echo ucfirst($order_details['payment_method']); ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Order Details</h6>
                                        <p><strong>Total Items:</strong> <?php echo count($order_details['items']); ?></p>
                                        <p><strong>Total Price:</strong> $<?php echo number_format($order_details['total'], 2); ?></p>
                                        <p><strong>Order Date:</strong> <?php echo date('F j, Y'); ?></p>
                                    </div>
                                </div>
                                <hr>
                                <h6>Items Purchased:</h6>
                                <ul class="list-group list-group-flush">
                                    <?php foreach ($order_details['items'] as $item): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <?php echo $item['item']['name']; ?> (x<?php echo $item['quantity']; ?>)
                                            <span>$<?php echo number_format($item['subtotal'], 2); ?></span>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <strong>Total Amount:</strong>
                                    <strong>$<?php echo number_format($order_details['total'], 2); ?></strong>
                                </div>
                            </div>
                        </div>
                        <div class="text-center mt-4">
                            <a href="index.php" class="btn btn-custom">
                                <i class="fas fa-home me-2"></i>Continue Shopping
                            </a>
                        </div>
                    </div>
                </div>
            <?php elseif (empty($cart_items)): ?>
                <!-- Empty Cart -->
                <div class="text-center">
                    <i class="fas fa-shopping-cart text-muted" style="font-size: 4rem;"></i>
                    <h3 class="text-muted mb-3">Your cart is empty</h3>
                    <p class="text-muted mb-4">Add some items to your cart before proceeding to checkout.</p>
                    <a href="index.php" class="btn btn-custom">
                        <i class="fas fa-arrow-left me-2"></i>Continue Shopping
                    </a>
                </div>
            <?php else: ?>
                <!-- Checkout Form -->
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="checkout-form">
                            <h4 class="mb-4">Shipping & Payment Information</h4>
                            <form method="POST">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="first_name" class="form-label">First Name</label>
                                        <input type="text" class="form-control" id="first_name" name="first_name" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="last_name" class="form-label">Last Name</label>
                                        <input type="text" class="form-control" id="last_name" name="last_name" required>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="address" class="form-label">Address</label>
                                    <textarea class="form-control" id="address" name="address" rows="3" required></textarea>
                                </div>
                                <div class="mb-4">
                                    <label class="form-label">Payment Method</label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="payment_method" id="visa" value="visa" required>
                                        <label class="form-check-label" for="visa">
                                            <i class="fab fa-cc-visa me-2"></i>Visa
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="payment_method" id="mastercard" value="mastercard" required>
                                        <label class="form-check-label" for="mastercard">
                                            <i class="fab fa-cc-mastercard me-2"></i>MasterCard
                                        </label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-custom w-100">
                                    <i class="fas fa-credit-card me-2"></i>Complete Order
                                </button>
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="order-summary">
                            <h5 class="mb-3">Order Summary</h5>
                            <ul class="list-group list-group-flush mb-3">
                                <?php foreach ($cart_items as $item): ?>
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                        <?php echo $item['item']['name']; ?> (x<?php echo $item['quantity']; ?>)
                                        <span>$<?php echo number_format($item['subtotal'], 2); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <hr>
                            <div class="d-flex justify-content-between">
                                <strong>Total:</strong>
                                <strong>$<?php echo number_format($total, 2); ?></strong>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-2 footer">
        <div class="container text-center">
            <p class="mb-0">&copy; 2026 Jewelry Store. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>