<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jewelry Store</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px 0;
            margin-bottom: 20px;
        }
        .item-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: none;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        .item-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }
        .item-image {
            height: 180px;
            object-fit: cover;
        }
        .price-tag {
            font-size: 1.1rem;
            font-weight: bold;
            color: #28a745;
        }
        .category-badge-link {
            text-decoration: none;
            transition: transform 0.2s ease;
        }
        .category-badge-link:hover {
            transform: scale(1.05);
        }
        .filter-section {
            background: #f8f9fa;
            padding: 15px 0;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .btn-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 8px 20px;
            color: white;
            transition: all 0.3s ease;
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .cart-icon {
            position: relative;
        }
        .cart-count {
            position: absolute;
            top: -10px;
            right: -10px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 0.8rem;
            min-width: 20px;
            text-align: center;
        }
        .main-content {
            flex: 1;
        }
        .footer {
            margin-top: auto;
        }
        .navbar {
            padding: 0.5rem 0;
        }
        .display-4 {
            font-size: 2.5rem;
        }
        .lead {
            font-size: 1.1rem;
        }
    </style>
</head>
<body>
    <?php

    session_start();
    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $qty) {
            $cart_count += $qty;
        }
    }
    $items = json_decode(file_get_contents('data/items.json'), true);
    $categories = array_unique(array_column($items, 'category'));

    $search = isset($_GET['search']) ? $_GET['search'] : '';
    $sort = isset($_GET['sort']) ? $_GET['sort'] : '';
    $category = isset($_GET['category']) ? $_GET['category'] : '';

    // Filter
    $filtered_items = $items;
    if ($search) {
        $filtered_items = array_filter($filtered_items, function($item) use ($search) {
            return stripos($item['name'], $search) !== false;
        });
    }
    if ($category) {
        $filtered_items = array_filter($filtered_items, function($item) use ($category) {
            return $item['category'] == $category;
        });
    }

    // Sort
    if ($sort == 'price_asc') {
        usort($filtered_items, function($a, $b) { return $a['price'] <=> $b['price']; });
    } elseif ($sort == 'price_desc') {
        usort($filtered_items, function($a, $b) { return $b['price'] <=> $a['price']; });
    }
    ?>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-gem me-2"></i>Jewelry Store
            </a>
            <div class="navbar-nav ms-auto">
                <div class="nav-item cart-icon">
                    <a class="nav-link" href="cart.php">
                        <i class="fas fa-shopping-cart fa-lg"></i>
                        <span class="cart-count"><?php echo $cart_count; ?></span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <div class="main-content">
        <!-- Hero Section -->
        <section class="hero-section">
            <div class="container text-center">
                <h1 class="display-4 mb-2">Discover Beautiful Jewelry</h1>
                <p class="lead mb-0">Find the perfect piece for every occasion</p>
            </div>
        </section>

        <!-- Filter Section -->
        <div class="container">
            <div class="filter-section">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <form method="GET" class="row g-2">
                            <div class="col-md-4">
                                <input type="text" class="form-control" name="search" placeholder="Search jewelry..." value="<?php echo htmlspecialchars($search); ?>">
                            </div>
                            <div class="col-md-3">
                                <select name="sort" class="form-select" onchange="this.form.submit()">
                                    <option value="">Sort by Price</option>
                                    <option value="price_asc" <?php if ($sort == 'price_asc') echo 'selected'; ?>>Low to High</option>
                                    <option value="price_desc" <?php if ($sort == 'price_desc') echo 'selected'; ?>>High to Low</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="category" class="form-select">
                                    <option value="">All Categories</option>
                                    <?php foreach ($categories as $cat): ?>
                                        <option value="<?php echo $cat; ?>" <?php if ($category == $cat) echo 'selected'; ?>><?php echo $cat; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-custom w-100">
                                    <i class="fas fa-search me-1"></i>Search
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Items Grid -->
            <div class="row">
                <?php foreach ($filtered_items as $item): ?>
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card item-card h-100">
                            <img src="<?php echo $item['images'][0]; ?>" class="card-img-top item-image" alt="<?php echo $item['name']; ?>">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><?php echo $item['name']; ?></h5>
                                <p class="card-text text-muted small"><?php echo substr($item['description'], 0, 80) . '...'; ?></p>
                                <div class="mt-auto">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="price-tag">$<?php echo number_format($item['price'], 2); ?></span>
                                        <a href="index.php?<?php echo http_build_query(array_merge($_GET, ['category' => $item['category']])); ?>" class="category-badge-link">
                                            <span class="category-badge"><?php echo $item['category']; ?></span>
                                        </a>
                                    </div>
                                    <a href="item.php?id=<?php echo $item['id']; ?>" class="btn btn-custom w-100">
                                        <i class="fas fa-eye me-1"></i>View Details
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <?php if (empty($filtered_items)): ?>
                <div class="text-center py-3">
                    <i class="fas fa-search fa-2x text-muted mb-2"></i>
                    <h4 class="text-muted">No items found</h4>
                    <p class="text-muted">Try adjusting your search criteria</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-2 footer">
        <div class="container text-center">
            <p class="mb-0">&copy; 2026 Jewelry Store. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>