<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item Details - Jewelry Store</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px 0;
        }
        .item-detail-card {
            border: none;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        .item-image {
            height: 250px;
            object-fit: cover;
            cursor: pointer;
            transition: transform 0.3s ease;
        }
        .item-image:hover {
            transform: scale(1.05);
        }
        .price-display {
            font-size: 1.8rem;
            font-weight: bold;
            color: #28a745;
            margin: 15px 0;
        }
        .category-badge {
            background: #f8f9fa;
            color: #6c757d;
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.85rem;
            display: inline-block;
            margin-bottom: 15px;
        }
        .btn-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 10px 25px;
            color: white;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .cart-icon {
            position: relative;
        }
        .cart-count {
            position: absolute;
            top: -10px;
            right: -10px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 0.8rem;
            min-width: 20px;
            text-align: center;
        }
        .image-gallery {
            display: flex;
            gap: 10px;
            overflow-x: auto;
            padding: 10px 0;
        }
        .gallery-thumb {
            width: 70px;
            height: 70px;
            object-fit: cover;
            border-radius: 8px;
            cursor: pointer;
            border: 2px solid transparent;
            transition: border-color 0.3s ease;
        }
        .gallery-thumb:hover {
            border-color: #667eea;
        }
        .gallery-thumb.active {
            border-color: #667eea;
        }
        .quantity-input {
            width: 80px;
            text-align: center;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }
        .main-content {
            flex: 1;
        }
        .footer {
            margin-top: auto;
        }
        .navbar {
            padding: 0.5rem 0;
        }
        .display-5 {
            font-size: 2.2rem;
        }
    </style>
    </style>
</head>
<body>
    <?php
    session_start();
    $cart_count = 0;
    if (isset($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $qty) {
            $cart_count += $qty;
        }
    }

    $items = json_decode(file_get_contents('data/items.json'), true);
    $item = null;
    if (isset($_GET['id'])) {
        foreach ($items as $i) {
            if ($i['id'] == $_GET['id']) {
                $item = $i;
                break;
            }
        }
    }

    if (!$item) {
        echo "<div class='container mt-5'><div class='alert alert-danger text-center'><h4>Item not found</h4><a href='index.php' class='btn btn-primary'>Back to Store</a></div></div>";
        exit;
    }

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_to_cart'])) {
        $qty = isset($_POST['quantity']) ? (int)$_POST['quantity'] : 1;
        if (!isset($_SESSION['cart'])) {
            $_SESSION['cart'] = [];
        }
        if (isset($_SESSION['cart'][$item['id']])) {
            $_SESSION['cart'][$item['id']] += $qty;
        } else {
            $_SESSION['cart'][$item['id']] = $qty;
        }
        header("Location: item.php?id=" . $item['id'] . "&added=1");
        exit;
    }

    $added = isset($_GET['added']);
    ?>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-gem me-2"></i>Jewelry Store
            </a>
            <div class="navbar-nav ms-auto">
                <div class="nav-item cart-icon">
                    <a class="nav-link" href="cart.php">
                        <i class="fas fa-shopping-cart fa-lg"></i>
                        <span class="cart-count"><?php echo $cart_count; ?></span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <div class="main-content">
        <!-- Hero Section -->
        <section class="hero-section">
            <div class="container text-center">
                <h1 class="display-5 mb-1"><?php echo $item['name']; ?></h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center bg-transparent p-0 m-0">
                        <li class="breadcrumb-item"><a href="index.php" class="text-white">Home</a></li>
                        <li class="breadcrumb-item"><a href="index.php?category=<?php echo urlencode($item['category']); ?>" class="text-white"><?php echo $item['category']; ?></a></li>
                        <li class="breadcrumb-item active text-light" aria-current="page"><?php echo $item['name']; ?></li>
                    </ol>
                </nav>
            </div>
        </section>

        <div class="container my-3">
            <?php if ($added): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>Item added to cart successfully!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <!-- Images Column -->
                <div class="col-lg-6 mb-3">
                    <div class="card item-detail-card">
                        <div class="card-body p-0">
                            <img id="main-image" src="<?php echo $item['images'][0]; ?>" class="card-img-top item-image" alt="<?php echo $item['name']; ?>">
                        </div>
                    </div>
                    <?php if (count($item['images']) > 1): ?>
                        <div class="image-gallery mt-2">
                            <?php foreach ($item['images'] as $index => $img): ?>
                                <img src="<?php echo $img; ?>" class="gallery-thumb <?php echo $index === 0 ? 'active' : ''; ?>" onclick="changeImage(this.src, this)" alt="View <?php echo $index + 1; ?>">
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Details Column -->
                <div class="col-lg-6">
                    <div class="card item-detail-card h-100">
                        <div class="card-body d-flex flex-column">
                            <div class="mb-2">
                                <span class="category-badge"><?php echo $item['category']; ?></span>
                            </div>

                            <h3 class="card-title mb-2"><?php echo $item['name']; ?></h3>

                            <p class="card-text text-muted mb-3"><?php echo $item['description']; ?></p>

                            <div class="price-display mb-3">
                                $<?php echo number_format($item['price'], 2); ?>
                            </div>

                            <form method="POST" class="mt-auto">
                                <div class="row g-3 align-items-end">
                                    <div class="col-sm-4">
                                        <label for="quantity" class="form-label fw-bold">Quantity</label>
                                        <input type="number" class="form-control quantity-input" name="quantity" value="1" min="1" max="99">
                                    </div>
                                    <div class="col-sm-8">
                                        <button type="submit" name="add_to_cart" class="btn btn-custom w-100">
                                            <i class="fas fa-cart-plus me-2"></i>Add to Cart
                                        </button>
                                    </div>
                                </div>
                            </form>

                            <div class="mt-3 pt-2 border-top">
                                <div class="row text-center">
                                    <div class="col-4">
                                        <i class="fas fa-shipping-fast fa-lg text-muted mb-1"></i>
                                        <div class="small">Free Shipping</div>
                                    </div>
                                    <div class="col-4">
                                        <i class="fas fa-undo fa-lg text-muted mb-1"></i>
                                        <div class="small">30-Day Returns</div>
                                    </div>
                                    <div class="col-4">
                                        <i class="fas fa-shield-alt fa-lg text-muted mb-1"></i>
                                        <div class="small">Secure Payment</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-2 footer">
        <div class="container text-center">
            <p class="mb-0">&copy; 2026 Jewelry Store. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function changeImage(src, thumb) {
            document.getElementById('main-image').src = src;
            // Remove active class from all thumbnails
            document.querySelectorAll('.gallery-thumb').forEach(img => img.classList.remove('active'));
            // Add active class to clicked thumbnail
            thumb.classList.add('active');
        }
    </script>
</body>
</html>