%{
#include <stdio.h>
#include <string.h>
int yyline;
int yylex();
struct promenljive{
   char ime[32];
   float vred;};
struct promenljive prom[100];

int brprom=0;

void dodajvar(char*,float);
float vredvar(char*);
float st2fl(char*);
%}

%start list
%union {
    float fval;
    char name[32];}

%token <name> NUMBER VAR
%type <fval> expr stat
%left <fval> '+' '-'
%left <fval> '*' '/'

%%

list : stat;
list : list stat;

stat : VAR '=' expr ';'
     { dodajvar($1,$3);
	   printf("%s = %f\n",$1,$3);}
     ;

expr : '(' expr ')'
     { $$=$2;}
     | expr '+' expr
     { $$=$1+$3;}
     | expr '-' expr
     { $$=$1-$3;}
     | expr '*' expr
     { $$=$1*$3;}
     | expr '/' expr
     { $$=$1/$3;}
     | '-' expr %prec '*'
     { $$=-$2;}
     | NUMBER
     { $$=st2fl($1);}
     | VAR
     { $$=vredvar($1);}
     ;

%%

int yyerror(char *s){
  printf("\n Greska %s u redu %d\n",s,yyline);
}

void dodajvar(char *s,float d){
   strcpy(prom[brprom].ime,s);
   prom[brprom++].vred=d;
}

float vredvar(char *s){
  int i,k;
  for(i=0;i<brprom;i++) 
    if(strcmp(prom[i].ime,s)==0) return prom[i].vred;
  if(i==brprom) return 0;
}


float st2fl(char s[]){
   float k=0,k1=0;
   int i=0,n,d=1;
   n=strlen(s);
   while(i<n && s[i]!='.'){
      k=k*10+(float)(s[i]-'0');
      i++;
   }
   if(s[i]=='.') {
      i++;
      while(i<n){
         k1=k1*10+(s[i]-'0');
         d*=10;
         i++;
      }
   }
   k=k+k1/(float)d; 
   return k;
}

main(){
  extern FILE *yyin;
  yyline=1;
  yyin=fopen("izrazi.txt","r");
  if (yyparse()==0) printf("\n Parsiranje uspesno zavrseno\n");
  else printf("\n Parsiranje nije uspesno zavrseno\n");
}
