(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44598,       1095]
NotebookOptionsPosition[     41907,       1016]
NotebookOutlinePosition[     42250,       1031]
CellTagsIndexPosition[     42207,       1028]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"20", 
     RowBox[{"Log", "[", "x", "]"}]}], "+", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "32"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5354748273061895`*^9, 3.535475167946673*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVynk4FGgAx/E58Mq1wzory5BjlIyj3N5fkmg3Smw9U4kRrakl08E+pZRs
1IbSlpJiK6V6WKu72B7ZSM4HaeiQ5BwZcmUadveP7/P558sVxgZFshgMxur/
+t/ozjE1BkNGJTx1JwaDAz/2J/dkloyGaayQD6lzYG3Zu0NFWUbzeJEMiQEH
Pdsl9RpqMrphYKiqwI6DrZNlp4x0ZXSnpU0kdwsHYVpH5zpay2j1d/mXsso4
+NHDyCZqjYze1vWDOEEbPtme/rV5MqoacfaaX48OzuhNq5kEjtBM89W22m/0
MGJSvad7ZIQydzd5Sn8xhEWNcWLCyVEaIJ+36VjvXDS49pIsr8+U7xro3Bpl
jOSlFe6mnZ+p2fcv5ZG5Jiia4nx2zBijt4LfBtSNmqJE0Our7z5ORT9J04fY
Zij3b1i+vWOcnqPe6vcmzbBsxqbSN22C3lW3mrth3Bz1NHvo9MJJGtYVYcCT
LIAT90RpSc0kVRUsTjUssQCnevxrcPwUbWN3/2x72hIT8thhkeEXymww61sh
tELQ+OZIUvWFfqtBj+7wsMbR9OZ4sXiazqcuG9dq8fDstsBxjY6c2gmdo3kN
POzLCxHf/ltO3T6s4BhftIGbkVBwPPwrvczlsnRCFyJ2fdc/fRwFdZxJZt2x
XYTEJQN1umUK2ll5pdB8ehF+z2MfLN08Q3NtAmrsH9rCvCmz9JX6LLXL2zv2
9LfFeJRud3Jn0SxVpMVuCw22g97EjZRBSwbMzrfY1GnykUoSlISJDCiLDncs
389H0ru6Nu16BmpfSjumPvLhdP6N9IgFExZiqxeNG+3RssB+zZZ9TFxtLI32
bLbHlz2aqrteMJHmowgN9nWApPAyc5UZCx+eHzA9VeUArysVgYJdLJzV8GSW
+TgiI8ZC2lTBwsBK0XV2pSNy5nnXaBixcX9doSh3nRMWZfR+TYpmo95gtN3w
nRMSPvrG3X/CBqttV0vx/iXwZ9m58XSUoNo9rs7XXwoyLFjLFCrh0lmZ3/hf
S5FUjhsX7ithMKvdNGqrMw4EF6+Pm6OM3SLzB37aLnCua/OdE66MxOevrUZb
XPBaz+eI6j1lTBVfcGjNdYWKhav+MqKCT9ncc6JwNwzq9/V7hKogqyhA/7mX
O0IaTHTExSp4lHUvOkXfA7fW56RqzaqAV5oa3zzqgfKKRsSEEOg4hHdpST0R
Mpa+mhQQlEwt/zP1rRcq6r35sdcI3JIacyRdXuAXTui0XSdY9U3CDwt7vaAR
Gvqq4CbBns4jisZhL1RW2Ub4lhDYHDqRb8GkcMipTUh5TNClMW/OmDkFx1vt
CruZIH9QT9dSRHFgfvmv21sI5OzstowYCulEXHRzK0FLwLmIaTFF9U3J4suv
CJz6Ulqb9lEc1Ct84P2WYJPajPmxExSf+lY2HOonSGg3STYtodj0VF7SP0CQ
puTfceYORU1u8em1UoLZnj8Umg8pCoIMBNxhgiJeSP5MBcXmxz3dT8YIbr4v
3Nbf8t9/5nyV9QSBqmagbpSEwiUu4EbmJMHeTMXxD28odC3vxoZNE2zt63rd
2UNxmCEKqpYTxHQG3g0bpJC1Gy/hKwguxjtsfD9MEXqnySB7hqCh/OoL4RhF
bUbK9OwswaFnleTjFMW/hpEiBQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1, 3}, {0, 32}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{{3.5354748434811144`*^9, 3.535474855780818*^9}, {
   3.535474887913656*^9, 3.5354751684096994`*^9}, 3.5354772258253765`*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.535476798444932*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "3"}]}], "+", 
   RowBox[{"5", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"20", 
    RowBox[{"Log", "[", "x", "]"}]}], "+", "2"}]}]], "Input",
 CellChangeTimes->{{3.5354757024132423`*^9, 3.535475734483077*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "1"}], ";", 
  RowBox[{"b", "=", "3"}], ";"}]], "Input",
 CellChangeTimes->{{3.535475762958706*^9, 3.5354757867920685`*^9}, 
   3.535477199441868*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"n", "=", "2"}], ",", 
   RowBox[{"n", "\[LessEqual]", "100"}], ",", 
   RowBox[{"n", "+=", "2"}], ",", 
   RowBox[{
    RowBox[{"h", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}], "/", "n"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ff", "=", 
     RowBox[{"f", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"a", "+", 
         RowBox[{"k", " ", "h"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"smin", "=", 
     RowBox[{"h", " ", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"Min", "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"ff", "[", 
           RowBox[{"[", 
            RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"smax", "=", 
     RowBox[{"h", " ", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"ff", "[", 
           RowBox[{"[", 
            RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", " ", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<n=\>\"", ",", "n", ",", "\"\<  \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"smin", ",", "16"}], "]"}], ",", "\"\<   \>\"", ",", 
      RowBox[{"N", "[", 
       RowBox[{"smax", ",", "16"}], "]"}], ",", "\"\<   Sredina: \>\"", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"smin", ",", "16"}], "]"}], "+", 
         RowBox[{"N", "[", 
          RowBox[{"smax", ",", "16"}], "]"}]}], ")"}], "/", "2"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5354769066021185`*^9, 3.5354769997464457`*^9}, 
   3.535477038408657*^9, {3.535477236563991*^9, 3.5354772394201546`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "19.86294361119890618748960731121`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "47.83518938456110001539451204966`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.84906649788000310144205968044`16."}],
  SequenceForm[
  "n=", 2, "  ", 19.862943611198906`16., "   ", 47.8351893845611`16., 
   "   Sredina: ", 33.849066497880003`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772403602085`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "26.39903020542264756536020692793`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "40.38515309210374447931265929715`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.39209164876319602233643311254`16."}],
  SequenceForm[
  "n=", 4, "  ", 26.399030205422648`16., "   ", 40.385153092103744`16., 
   "   Sredina: ", 33.392091648763196`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772403652086`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "28.65039845302949698909033253051`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "37.97448037748356159839196744322`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.31243941525652929374114998686`16."}],
  SequenceForm[
  "n=", 6, "  ", 28.650398453029497`16., "   ", 37.974480377483562`16., 
   "   Sredina: ", 33.312439415256529`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772403672085`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "29.78846743843352943878354924803`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "36.78152888177407789575977543264`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.28499816010380366727166234034`16."}],
  SequenceForm[
  "n=", 8, "  ", 29.788467438433529`16., "   ", 36.781528881774078`16., 
   "   Sredina: ", 33.284998160103804`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240375209*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "30.47515291219892853758459201589`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "36.06960206687136730316557296351`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.2723774895351479203750824897`16."}],
  SequenceForm[
  "n=", 10, "  ", 30.475152912198929`16., "   ", 36.069602066871367`16., 
   "   Sredina: ", 33.272377489535148`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240377209*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "30.93452321835690589618870088507`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "35.59656418058393820083951834159`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.26554369947042204851410961332`16."}],
  SequenceForm[
  "n=", 12, "  ", 30.934523218356906`16., "   ", 35.596564180583938`16., 
   "   Sredina: ", 33.265543699470422`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240380209*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "31.26341311582978952717308269182`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "35.2594482263101029311594976544`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.26143067106994622916629017311`16."}],
  SequenceForm[
  "n=", 14, "  ", 31.26341311582979`16., "   ", 35.259448226310103`16., 
   "   Sredina: ", 33.261430671069946`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772403992105`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "31.51049884955396104552744465012`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "35.00702957122423527401555774243`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25876421038909815977150119627`16."}],
  SequenceForm[
  "n=", 16, "  ", 31.510498849553961`16., "   ", 35.007029571224235`16., 
   "   Sredina: ", 33.258764210389098`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240415211*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "31.70292383436458250074674196965`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.81095114251593737051395360721`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25693748844025993563034778843`16."}],
  SequenceForm[
  "n=", 18, "  ", 31.702923834364583`16., "   ", 34.810951142515937`16., 
   "   Sredina: ", 33.25693748844026`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772404322124`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "31.85701925441125143692821663848`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.65424383174747081971870711247`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25563154307936112832346187548`16."}],
  SequenceForm[
  "n=", 20, "  ", 31.857019254411251`16., "   ", 34.654243831747471`16., 
   "   Sredina: ", 33.255631543079361`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240448213*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "31.98319994978992876902301446723`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.52613138373194638974164217078`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25466566676093757938232831901`16."}],
  SequenceForm[
  "n=", 22, "  ", 31.983199949789929`16., "   ", 34.526131383731946`16., 
   "   Sredina: ", 33.254665666760938`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772404652143`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.08842101224273940489008093521`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.4194414933562555572154896633`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25393125279949748105278529926`16."}],
  SequenceForm[
  "n=", 24, "  ", 32.088421012242739`16., "   ", 34.419441493356256`16., 
   "   Sredina: ", 33.253931252799497`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772404832153`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.17750422758291459803790082642`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.32921544091846796941520119088`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25335983425069128372655100866`16."}],
  SequenceForm[
  "n=", 26, "  ", 32.177504227582915`16., "   ", 34.329215440918468`16., 
   "   Sredina: ", 33.253359834250691`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240509217*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.25389773342393346626943700198`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.25191528866409016826264448345`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25290651104401181726604074272`16."}],
  SequenceForm[
  "n=", 28, "  ", 32.253897733423933`16., "   ", 34.25191528866409`16., 
   "   Sredina: ", 33.252906511044012`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240528218*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.32013265214328960099548056613`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.18494903703410252285580754868`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25254084458869606192564405741`16."}],
  SequenceForm[
  "n=", 30, "  ", 32.32013265214329`16., "   ", 34.184949037034103`16., 
   "   Sredina: ", 33.252540844588696`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240546219*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.37810892726559662263207660883`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.126374288100733736876133155`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25224160768316517975410488191`16."}],
  SequenceForm[
  "n=", 32, "  ", 32.378108927265597`16., "   ", 34.126374288100734`16., 
   "   Sredina: ", 33.252241607683165`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772405662203`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.42928051988077599302991382256`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.0747067418432579829066729248`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25199363086201698796829337368`16."}],
  SequenceForm[
  "n=", 34, "  ", 32.429280519880776`16., "   ", 34.074706741843258`16., 
   "   Sredina: ", 33.251993630862017`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772405832205`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.47477901317968761590595178619`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "34.02879266725536505078955760515`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25178584021752633334775469568`16."}],
  SequenceForm[
  "n=", 36, "  ", 32.474779013179688`16., "   ", 34.028792667255365`16., 
   "   Sredina: ", 33.251785840217526`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772405992217`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.51549826777258723753341881997`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.98772172952849217584420327976`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25160999865053970668881104987`16."}],
  SequenceForm[
  "n=", 38, "  ", 32.515498267772587`16., "   ", 33.987721729528492`16., 
   "   Sredina: ", 33.25160999865054`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772406272235`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.55215373209035672878159438226`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.95076602075846642017683961926`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25145987642441157447921700076`16."}],
  SequenceForm[
  "n=", 40, "  ", 32.552153732090357`16., "   ", 33.950766020758466`16., 
   "   Sredina: ", 33.251459876424412`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772406452246`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.58532483973428293039278218174`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.91733654322772073172158716927`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25133069148100183105718467551`16."}],
  SequenceForm[
  "n=", 42, "  ", 32.585324839734283`16., "   ", 33.917336543227721`16., 
   "   Sredina: ", 33.251330691481002`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772406622257`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "44", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.61548586522597774699834247712`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.8869515821969865573576563289`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25121872371148215217799940301`16."}],
  SequenceForm[
  "n=", 44, "  ", 32.615485865225978`16., "   ", 33.886951582196987`16., 
   "   Sredina: ", 33.251218723711482`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772406782265`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "46", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.64302874460291715483282389404`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.85921334344475166908955888263`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25112104402383441196119138834`16."}],
  SequenceForm[
  "n=", 46, "  ", 32.643028744602917`16., "   ", 33.859213343444752`16., 
   "   Sredina: ", 33.251121044023834`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772406992273`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.66828020047893887616903198222`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.83379044103569695233173634645`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25103532075731791425038416433`16."}],
  SequenceForm[
  "n=", 48, "  ", 32.668280200478939`16., "   ", 33.833790441035697`16., 
   "   Sredina: ", 33.251035320757318`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772407162285`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "50", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.69151476373162182914444925863`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.81040459466610958226064544801`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25095967919886570570254735333`16."}],
  SequenceForm[
  "n=", 50, "  ", 32.691514763731622`16., "   ", 33.81040459466611`16., 
   "   Sredina: ", 33.250959679198866`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772407352295`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "52", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.71296479484929579992049948113`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.78882040151707248560914966354`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25089259818318414276482457233`16."}],
  SequenceForm[
  "n=", 52, "  ", 32.712964794849296`16., "   ", 33.788820401517072`16., 
   "   Sredina: ", 33.250892598183184`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772407582307`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "54", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.73282828163779153886945538144`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.76883738435490982879185926051`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25083283299635068383065732098`16."}],
  SequenceForm[
  "n=", 54, "  ", 32.732828281637792`16., "   ", 33.76883738435491`16., 
   "   Sredina: ", 33.250832832996351`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240778232*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.75127496839435735295179378806`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.75028374601443570394839752862`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25077935720439652845009565833`16."}],
  SequenceForm[
  "n=", 56, "  ", 32.751274968394357`16., "   ", 33.750283746014436`16., 
   "   Sredina: ", 33.250779357204397`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772407952332`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.76845121873712229816688973196`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.73301141781857725774981748147`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25073131827784977795835360671`16."}],
  SequenceForm[
  "n=", 58, "  ", 32.768451218737122`16., "   ", 33.733011417818577`16., 
   "   Sredina: ", 33.25073131827785`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240812234*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.78448390717300535070067367983`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.71689209961841181163083717128`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25068800339570858116575542555`16."}],
  SequenceForm[
  "n=", 60, "  ", 32.784483907173005`16., "   ", 33.716892099618412`16., 
   "   Sredina: ", 33.250688003395709`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240829235*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "62", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.79948355843591160452218536327`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.70181406725404688929331132255`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25064881284497924690774834291`16."}],
  SequenceForm[
  "n=", 62, "  ", 32.799483558435912`16., "   ", 33.701814067254047`16., 
   "   Sredina: ", 33.250648812844979`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240846236*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.81354689893825513999479540807`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.68767957935582369711682368114`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25061323914703941855580954461`16."}],
  SequenceForm[
  "n=", 64, "  ", 32.813546898938255`16., "   ", 33.687679579355824`16., 
   "   Sredina: ", 33.250613239147039`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240863237*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "66", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.82675894488686585195389058055`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.67440275620087172552676648175`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25058085054386878874032853115`16."}],
  SequenceForm[
  "n=", 66, "  ", 32.826758944886866`16., "   ", 33.674402756200872`16., 
   "   Sredina: ", 33.250580850543869`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240880238*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "68", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.83919472234298894884288755431`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.66190783332422994378126710561`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25055127783360944631207732996`16."}],
  SequenceForm[
  "n=", 68, "  ", 32.839194722342989`16., "   ", 33.66190783332423`16., 
   "   Sredina: ", 33.250551277833609`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240899239*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "70", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.85092069275295910987896152907`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.65012771484902179067624452159`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25052420380099045027760302532`16."}],
  SequenceForm[
  "n=", 70, "  ", 32.850920692752959`16., "   ", 33.650127714849022`16., 
   "   Sredina: ", 33.25052420380099`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772409162397`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "72", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.86199594115518222972763015893`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.63900276819302094716943306841`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25049935467410158844853161367`16."}],
  SequenceForm[
  "n=", 72, "  ", 32.861995941155182`16., "   ", 33.639002768193021`16., 
   "   Sredina: ", 33.250499354674102`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477240936241*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.87247317191373674120215948581`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.6284798144370392770914812354`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.2504764931753880091468203606`16."}],
  SequenceForm[
  "n=", 74, "  ", 32.872473171913737`16., "   ", 33.628479814437039`16., 
   "   Sredina: ", 33.250476493175388`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772409592423`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "76", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.88239954739673839268979685511`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.61851127827469086184518908519`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25045541283571462726749297015`16."}],
  SequenceForm[
  "n=", 76, "  ", 32.882399547396738`16., "   ", 33.618511278274691`16., 
   "   Sredina: ", 33.250455412835715`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772409792433`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "78", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.8918173977598476599319462873`16.", "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", "33.60905446887169878372437974212`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25043593331577322182816301471`16."}],
  SequenceForm[
  "n=", 78, "  ", 32.891817397759848`16., "   ", 33.609054468871699`16., 
   "   Sredina: ", 33.250435933315773`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772409962444`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "80", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.9007648243688858748516333515`16.", "\[InvisibleSpace]", "\<\"   \"\>", 
   "\[InvisibleSpace]", "33.60007096870294072054925596982`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25041789653591329770044466066`16."}],
  SequenceForm[
  "n=", 80, "  ", 32.900764824368886`16., "   ", 33.600070968702941`16., 
   "   Sredina: ", 33.250417896535913`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772410142455`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.90927621500296584579450399814`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.59152611191423886598730655259`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25040116345860235589090527536`16."}],
  SequenceForm[
  "n=", 82, "  ", 32.909276215002966`16., "   ", 33.591526111914239`16., 
   "   Sredina: ", 33.250401163458602`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772410322466`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "84", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.91738268552734299170375406542`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.58338853727406189236815655937`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25038561140070244203595531239`16."}],
  SequenceForm[
  "n=", 84, "  ", 32.917382685527343`16., "   ", 33.583388537274062`16., 
   "   Sredina: ", 33.250385611400702`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772410532475`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "86", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.92511245999487042089390757588`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.57562980356143306805448675575`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25037113177815174447419716581`16."}],
  SequenceForm[
  "n=", 86, "  ", 32.92511245999487`16., "   ", 33.575629803561433`16., 
   "   Sredina: ", 33.250371131778152`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772410772495`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "88", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.93249119896258326087133000098`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.56822405744808766605098692669`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25035762820533546346115846384`16."}],
  SequenceForm[
  "n=", 88, "  ", 32.932491198962583`16., "   ", 33.568224057448088`16., 
   "   Sredina: ", 33.250357628205335`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772410962505`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.93954228407166279722861587995`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.56114774570193377118205820746`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25034501488679828420533704371`16."}],
  SequenceForm[
  "n=", 90, "  ", 32.939542284071663`16., "   ", 33.561147745701934`16., 
   "   Sredina: ", 33.250345014886798`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772411122513`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "92", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.94628706554055626918320501252`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.55437936496147352631157250699`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25033321525101489774738875975`16."}],
  SequenceForm[
  "n=", 92, "  ", 32.946287065540556`16., "   ", 33.554379364961474`16., 
   "   Sredina: ", 33.250333215251015`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477241130252*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "94", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.95274507809011753725414702667`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.54789924348080251231595351035`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25032216078546002478505026851`16."}],
  SequenceForm[
  "n=", 94, "  ", 32.952745078090118`16., "   ", 33.547899243480803`16., 
   "   Sredina: ", 33.25032216078546`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772411482534`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "96", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.95893422990059149694545248292`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.54168935017897053502680466486`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25031179003978101598612857389`16."}],
  SequenceForm[
  "n=", 96, "  ", 32.958934229900591`16., "   ", 33.541689350178971`16., 
   "   Sredina: ", 33.250311790039781`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477241166254*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "98", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.96487096844988812773967908895`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.53573312708993289973773836948`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25030204776991051373870872922`16."}],
  SequenceForm[
  "n=", 98, "  ", 32.964870968449888`16., "   ", 33.535733127089933`16., 
   "   Sredina: ", 33.250302047769911`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.535477241183255*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n=\"\>", "\[InvisibleSpace]", "100", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   "32.97057042646717449484896979171`16.", "\[InvisibleSpace]", "\<\"   \"\>",
    "\[InvisibleSpace]", "33.53001534193441837140706788657`16.", 
   "\[InvisibleSpace]", "\<\"   Sredina: \"\>", "\[InvisibleSpace]", 
   "33.25029288420079643312801883913`16."}],
  SequenceForm[
  "n=", 100, "  ", 32.970570426467174`16., "   ", 33.530015341934418`16., 
   "   Sredina: ", 33.250292884200796`16.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5354770059318*^9, 3.5354770393907137`*^9, {3.5354772299786143`*^9, 
   3.5354772412012568`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.5354770474701757`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "2"}], ")"}], "^", "3"}]}], "+", 
      RowBox[{"5", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{"20", 
       RowBox[{"Log", "[", "x", "]"}]}], "+", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", "16"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.535477048840254*^9, 3.53547707989703*^9}, {
  3.5354771275627565`*^9, 3.5354771284578075`*^9}}],

Cell[BoxData["33.25007065341991481704804754867`16."], "Output",
 CellChangeTimes->{{3.5354770615459805`*^9, 3.5354770804930644`*^9}, 
   3.535477129176849*^9, 3.5354772517298584`*^9}]
}, Open  ]]
},
WindowSize->{759, 758},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 617, 19, 31, "Input"],
Cell[1187, 43, 2141, 40, 249, "Output"]
}, Open  ]],
Cell[3343, 86, 87, 1, 52, "Input"],
Cell[3433, 89, 436, 14, 31, "Input"],
Cell[3872, 105, 194, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[4091, 114, 2224, 64, 132, "Input"],
Cell[CellGroupData[{
Cell[6340, 182, 686, 14, 23, "Print"],
Cell[7029, 198, 688, 14, 23, "Print"],
Cell[7720, 214, 688, 14, 23, "Print"],
Cell[8411, 230, 686, 14, 23, "Print"],
Cell[9100, 246, 687, 14, 23, "Print"],
Cell[9790, 262, 688, 14, 23, "Print"],
Cell[10481, 278, 688, 14, 23, "Print"],
Cell[11172, 294, 688, 14, 23, "Print"],
Cell[11863, 310, 689, 14, 23, "Print"],
Cell[12555, 326, 688, 14, 23, "Print"],
Cell[13246, 342, 690, 14, 23, "Print"],
Cell[13939, 358, 689, 14, 23, "Print"],
Cell[14631, 374, 688, 14, 23, "Print"],
Cell[15322, 390, 687, 14, 23, "Print"],
Cell[16012, 406, 687, 14, 23, "Print"],
Cell[16702, 422, 688, 14, 23, "Print"],
Cell[17393, 438, 689, 14, 23, "Print"],
Cell[18085, 454, 690, 14, 23, "Print"],
Cell[18778, 470, 689, 14, 23, "Print"],
Cell[19470, 486, 690, 14, 23, "Print"],
Cell[20163, 502, 690, 14, 23, "Print"],
Cell[20856, 518, 689, 14, 23, "Print"],
Cell[21548, 534, 690, 14, 23, "Print"],
Cell[22241, 550, 690, 14, 23, "Print"],
Cell[22934, 566, 689, 14, 23, "Print"],
Cell[23626, 582, 690, 14, 23, "Print"],
Cell[24319, 598, 687, 14, 23, "Print"],
Cell[25009, 614, 690, 14, 23, "Print"],
Cell[25702, 630, 687, 14, 23, "Print"],
Cell[26392, 646, 688, 14, 23, "Print"],
Cell[27083, 662, 688, 14, 23, "Print"],
Cell[27774, 678, 688, 14, 23, "Print"],
Cell[28465, 694, 688, 14, 23, "Print"],
Cell[29156, 710, 687, 14, 23, "Print"],
Cell[29846, 726, 689, 14, 23, "Print"],
Cell[30538, 742, 688, 14, 23, "Print"],
Cell[31229, 758, 688, 14, 23, "Print"],
Cell[31920, 774, 690, 14, 23, "Print"],
Cell[32613, 790, 689, 14, 23, "Print"],
Cell[33305, 806, 689, 14, 23, "Print"],
Cell[33997, 822, 690, 14, 23, "Print"],
Cell[34690, 838, 690, 14, 23, "Print"],
Cell[35383, 854, 689, 14, 23, "Print"],
Cell[36075, 870, 690, 14, 23, "Print"],
Cell[36768, 886, 690, 14, 23, "Print"],
Cell[37461, 902, 688, 14, 23, "Print"],
Cell[38152, 918, 689, 14, 23, "Print"],
Cell[38844, 934, 688, 14, 23, "Print"],
Cell[39535, 950, 688, 14, 23, "Print"],
Cell[40226, 966, 692, 14, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[40945, 984, 89, 1, 52, "Input"],
Cell[CellGroupData[{
Cell[41059, 989, 646, 20, 31, "Input"],
Cell[41708, 1011, 183, 2, 30, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
