(deftemplate BRZINA_RADA_MOTORA
2000 3000 opm
(
(sporo (2000 1)(2400 0))
(taman (2250 0)(2500 1)(2750 0))
(brzo (2600 0)(3000 1))
))

(deftemplate ULAZNA_VOLTAZA
2.3 2.5 V
(
(snizena (2.3 1)(2.4 0))
(uobicajena (2.38 0)(2.4 1)(2.42 0))
(povisena (2.4 0)(2.5 1))
)
)

(deftemplate motor
(slot brzina_rada (type FUZZY-VALUE BRZINA_RADA_MOTORA)))

(deftemplate ulaz
(slot voltaza (type FUZZY-VALUE ULAZNA_VOLTAZA))
)


(defrule crtanje1
=>
(plot-fuzzy-value t "*+." nil nil (create-fuzzy-value BRZINA_RADA_MOTORA sporo)
								  (create-fuzzy-value BRZINA_RADA_MOTORA taman)	
								  (create-fuzzy-value BRZINA_RADA_MOTORA brzo))
)

(defrule crtanje2
=>
(plot-fuzzy-value t "*+." nil nil (create-fuzzy-value ULAZNA_VOLTAZA snizena)
								  (create-fuzzy-value ULAZNA_VOLTAZA uobicajena)	
								  (create-fuzzy-value ULAZNA_VOLTAZA povisena))
)


(deffunction fazifikuj (?b)
(if (<= ?b  2300)
	then (assert (motor (brzina_rada sporo)))
	else (if (and (> ?b 2300)(< ?b 2700)) then (assert (motor (brzina_rada taman)))
		  else (assert (motor (brzina_rada brzo)))
		 )
)
)

(defrule sporo
(motor (brzina_rada sporo))
=>
(assert (ulaz (voltaza povisena))))

(defrule uobicajena
(motor (brzina_rada taman))
=>
(assert (ulaz (voltaza uobicajena))))

(defrule brzo
(motor (brzina_rada brzo))
=>
(assert (ulaz (voltaza snizena))))

(defrule unos
=>
(printout t "Unesi brzinu rada motora:" crlf)
(bind ?b (read))
(assert (brzina ?b))
)

(defrule provera
?f <- (brzina ?b)
(test (numberp ?b))
=>
(fazifikuj ?b)
(retract ?f))

(defrule provera1
?f <- (brzina ?b)
(test (not (numberp ?b)))
=>
(assert-string (format nil "(motor (brzina_rada %s))" ?b))
(retract ?f))

(defrule defuzzify
?f <- (ulaz (voltaza ?v))
=>
(printout t "Na ulaz treba dovesti " (moment-defuzzify ?v) " V" crlf))
