%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>


int yyline;
int yylex();

%}

%start list
%union {
    float fval;
    char name[32];}

%token <name> NUMBER F_COS F_SIN F_TG F_CTG
%type <fval> expr 
%left <fval> '+' '-'
%left <fval> '*' '/'

%%

list : expr
     { printf("%f\n",$1);}
     ;

expr : '(' expr ')'
     { $$=$2;}
     | expr '+' expr
     { $$=$1+$3;}
     | expr '-' expr
     { $$=$1-$3;}
     | expr '*' expr
     { $$=$1*$3;}
     | expr '/' expr
     { $$=$1/$3;}
     | '-' expr %prec '*'
     { $$=-$2;}
     | F_COS expr %prec '*'
     { $$=cos($2);}
     | F_SIN expr %prec '*'
     { $$=sin($2);}
     | F_TG expr %prec '*'
     { $$=tan($2);}
     | F_CTG expr %prec '*'
     { $$=1.0/tan($2);}
     | NUMBER
     { $$=atof($1);}
     ;

%%

int yyerror(char *s){
  printf("\n Greska %s u redu %d\n",s,yyline);
}


main(){
  extern FILE *yyin;
  yyline=1;
  yyin=fopen("izraz.txt","r");
  if (yyparse()==0) printf("\n Parsiranje uspesno zavrseno\n");
  else printf("\n Parsiranje nije uspesno zavrseno\n");
}
