%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#define eps 0.001

int yyline;
int yylex();

float value_pi();
float value_e();

%}

%start list
%union {
    float fval;
    char name[32];}

%token <name> NUMBER F_COS F_SIN F_TG F_CTG F_LN Const_PI Const_E
%type <fval> expr 
%left <fval> '+' '-'
%left <fval> '*' '/'

%%

list : expr
     { printf("%f\n",$1);}
     ;

expr : '(' expr ')'
     { $$=$2;}
     | expr '+' expr
     { $$=$1+$3;}
     | expr '-' expr
     { $$=$1-$3;}
     | expr '*' expr
     { $$=$1*$3;}
     | expr '/' expr
     { $$=$1/$3;}
     | '-' expr %prec '*'
     { $$=-$2;}
     | F_COS expr %prec '*'
     { $$=cos($2);}
     | F_SIN expr %prec '*'
     { $$=sin($2);}
     | F_TG expr %prec '*'
     { $$=tan($2);}
     | F_CTG expr %prec '*'
     { $$=1.0/tan($2);}
     | F_LN expr %prec '*'
     { $$=log($2);}
     | Const_PI
     { $$=value_pi();}
     | Const_E
     { $$=value_e();}
     | NUMBER
     { $$=atof($1);}
     ;

%%

int yyerror(char *s){
  printf("\n Greska %s u redu %d\n",s,yyline);
}


float value_pi(){
    float val=0.0,k=1.0;
    int i=0,sig=1;
    while(fabs(k)>=eps) {
        val+=k;
        sig=-sig;
        i++;
        k=(float)sig/(float)(2*i+1);
    }
    return 4*val;
}

float value_e(){
    float val=0.0,k=1.0;
    int i=0;
    while(k>=eps) {
        val+=k;
        i++;
        k=k/(float)i;
    }
    return val;
}


main(){
  extern FILE *yyin;
  yyline=1;
  yyin=fopen("izraz.txt","r");
  if (yyparse()==0) printf("\n Parsiranje uspesno zavrseno\n");
  else printf("\n Parsiranje nije uspesno zavrseno\n");
}
