
%{
#include <stdlib.h>
#include <stdio.h>
#include <string.h>


int yylex( void );
void dodaj(char*,int);
int vrati(char*);

int yyline=0;

enum {FALSE,TRUE};

struct slova{
     char *ime;
     int vrednost;
};

struct slova tabela[100];
int br_slova=0;

int i;


%}

/* ---------------------------------------------------------------------- */

%union
{
    int value;     
    char* name;
}

%token <name> ISK_SLOVO K_TRUE K_FALSE
%type <value> vred formula
%left O_AND
%left O_OR
%left O_THEN
%left O_IFF
%left O_NOT




%start ulaz

%%

ulaz : lista_slova '.' formula
       {for(i=0;i<br_slova;i++) printf("%s %d\n",tabela[i].ime,tabela[i].vrednost);
        printf("\n Vrednost formule je "); if($3) printf("TRUE\n"); else printf("FALSE\n");}
     ;

lista_slova : dodela
       | dodela lista_slova;

dodela : ISK_SLOVO '=' vred
     { dodaj(yylval.name,$3); }
     ;

vred : K_TRUE
      { $$ = TRUE;}
     | K_FALSE
      { $$ = FALSE;}
     ;

formula :
      '(' formula ')'
      {
        $$ = $2;
      } 
      | formula O_AND formula
      { 
        $$ = $1*$3;
      }
      | formula O_OR formula
      { 
        if(($1==TRUE) && ($3==TRUE)) $$ = FALSE;
        else $$ = TRUE;
      }
      | formula O_THEN formula
      { 
        if (($1==TRUE) && ($3==FALSE)) $$ = FALSE;
        else $$ = TRUE;
      }
      | formula O_IFF formula
      { 
        if ($1==$3) $$ = TRUE;
        else $$ = FALSE;
      }
      | O_NOT formula
      { 
        if ($2==TRUE) $$ = FALSE;
        else $$ = TRUE;
      }
      | ISK_SLOVO
      { 
        $$ = vrati(yylval.name);
      }
      ;

%%
/* ---------------------------------------------------------------------- */

int yyerror(char *s){
  printf("\n Greska %s u redu %d\n",s,yyline);
}


void dodaj(char *s, int v){
     tabela[br_slova].ime=(char *)malloc(strlen(s)+1);
     strcpy(tabela[br_slova].ime,s);
     tabela[br_slova++].vrednost=v;
}

int vrati(char *s){
     int i;
     for (i=0; i< br_slova; i++) 
         if(!strcmp(s,tabela[i].ime)) return tabela[i].vrednost;
     return TRUE;
}

main(){
  extern FILE *yyin;
  yyline=1;
  yyin=fopen("logika.txt","r");
  if (yyparse()==0) printf("\n Parsiranje uspesno zavrseno\n");
  else printf("\n Parsiranje nije uspesno zavrseno\n");
}


