(deftemplate biljka
(slot naziv)
(slot toplota)
(slot svetlost)
(slot mnogo-vode)
(slot saksijska)
(slot lako-odrzavanje)
(slot brzo-raste)
(slot CF))

(deffacts r
(biljka (naziv AAA) (toplota DA)(svetlost NE)(mnogo-vode DA)(saksijska DA)(lako-odrzavanje NE)(brzo-raste DA)(CF 0.0))
(biljka (naziv BBB) (toplota DA)(svetlost DA)(mnogo-vode DA)(saksijska DA)(lako-odrzavanje DA)(brzo-raste DA)(CF 0.0))
(biljka (naziv CCC) (toplota NE)(svetlost NE)(mnogo-vode NE)(saksijska NE)(lako-odrzavanje DA)(brzo-raste DA)(CF 0.0))
(biljka (naziv DDD) (toplota DA)(svetlost DA)(mnogo-vode DA)(saksijska DA)(lako-odrzavanje DA)(brzo-raste DA)(CF 0.0))
(biljka (naziv EEE) (toplota DA)(svetlost NE)(mnogo-vode DA)(saksijska DA)(lako-odrzavanje NE)(brzo-raste NE)(CF 0.0))
(biljka (naziv FFF) (toplota NE)(svetlost DA)(mnogo-vode NE)(saksijska NE)(lako-odrzavanje DA)(brzo-raste NE)(CF 0.0))
(biljka (naziv GGG) (toplota NE)(svetlost NE)(mnogo-vode DA)(saksijska NE)(lako-odrzavanje DA)(brzo-raste NE)(CF 0.0))
(biljka (naziv HHH) (toplota DA)(svetlost NE)(mnogo-vode NE)(saksijska DA)(lako-odrzavanje DA)(brzo-raste NE)(CF 0.0))
(biljka (naziv III) (toplota DA)(svetlost NE)(mnogo-vode DA)(saksijska DA)(lako-odrzavanje NE)(brzo-raste NE)(CF 0.0))
)

(defglobal ?*maxCF* = 0.0)

(deffunction proveri (?odgovor $?dozvoljeni_odgovori)
	(while (not (member ?odgovor $?dozvoljeni_odgovori)) do
		(printout t "Molim unesite ispravan odgovor. " crlf)
		(bind ?odgovor (read)))
	(return ?odgovor))
	
(defrule p1
=>
(printout t "Da li biljka voli toplotu?")
(bind ?odg (proveri (read) DA NE))
(assert (toplota ?odg))) 

(defrule p2
=>
(printout t "Da li biljka trazi svetlost?")
(bind ?odg (proveri (read) DA NE))
(assert (svetlost ?odg))) 

(defrule p3
=>
(printout t "Da li biljka voli mnogo-vode?")
(bind ?odg (proveri (read) DA NE))
(assert (voda ?odg))) 

(defrule p4
=>
(printout t "Da li je biljka saksijska?")
(bind ?odg (proveri (read) DA NE))
(assert (saksija ?odg))) 

(defrule p5
=>
(printout t "Da li se biljka lako odrzava?")
(bind ?odg (proveri (read) DA NE))
(assert (lako-odrzavanje ?odg))) 

(defrule p6
=>
(printout t "Da li biljka brzo raste?")
(bind ?odg (proveri (read) DA NE))
(assert (brzorastuca ?odg))) 

(defrule p7
?m<-(toplota ?t)
?f <- (biljka (toplota ?t)(CF ?cf))
(test (eq ?t DA))
=>
(modify ?f (toplota da)(CF (+ ?cf 1)))
)

(defrule p71
(toplota ?t)
?f <- (biljka (toplota ?t)(CF ?cf))
(test (eq ?t NE))
=>
(modify ?f (toplota ne)(CF (+ ?cf 1)))
)

(defrule p8
(svetlost ?t)
?f <- (biljka (svetlost ?t)(CF ?cf))
=>
(if (eq ?t DA) then
(modify ?f (svetlost da)(CF (+ ?cf 1)))
else
(modify ?f (svetlost ne)(CF (+ ?cf 1)))
))

(defrule p9
(voda ?t)
?f <- (biljka (mnogo-vode ?t)(CF ?cf))
=>
(if (eq ?t DA) then
(modify ?f (mnogo-vode da)(CF (+ ?cf 1)))
else
(modify ?f (mnogo-vode ne)(CF (+ ?cf 1)))
))

(defrule p10
(saksija ?t)
?f <- (biljka (saksijska ?t)(CF ?cf))
=>
(if (eq ?t DA) then
(modify ?f (saksijska da)(CF (+ ?cf 1)))
else
(modify ?f (saksijska ne)(CF (+ ?cf 1)))
))

(defrule p11
(lako-odrzavanje ?t)
?f <- (biljka (lako-odrzavanje ?t)(CF ?cf))
=>
(if (eq ?t DA) then
(modify ?f (lako-odrzavanje da)(CF (+ ?cf 1)))
else
(modify ?f (lako-odrzavanje da)(CF (+ ?cf 1)))
))

(defrule p12
(brzorastuca ?t)
?f <- (biljka (brzo-raste ?t)(CF ?cf))
=>
(if (eq ?t DA) then
(modify ?f (brzo-raste da)(CF (+ ?cf 1)))
else
(modify ?f (brzo-raste da)(CF (+ ?cf 1)))
))

(defrule p13
(declare (salience -10))
(biljka (CF ?cf))
=>
(if (> ?cf ?*maxCF*) then
(bind ?*maxCF* ?cf)
)
)

(defrule p15
(declare (salience -15))
=>
(assert (MAX ?*maxCF*)))


(defrule p14
(MAX ?m)
(biljka (naziv ?n)(CF ?c))
(test (= ?c ?m))
=>
(printout t ?n crlf)
)
