import java.net.*;
import java.io.*;

public class TcpClient {

	// Port je konstanta, mora da bude isti za klijent i server
	private static final int PORT = 12345;

	public static void main(String[] args) throws IOException {

		if (args.length != 2) {
			System.out.println("Koriscenje: java TcpClient hostname filename");
			System.exit(0);
		}

		// Konekcija na dati host
		InetAddress address = InetAddress.getByName(args[0]);

		// Pokusaj konekcije na TcpServer
		Socket socket = new Socket(address, PORT);

		try {
			PrintWriter out = new PrintWriter(new BufferedWriter(
					new OutputStreamWriter(socket.getOutputStream())), true);

			BufferedReader in = new BufferedReader(new InputStreamReader(socket
					.getInputStream()));

			// posalji ime fajla
			out.println(args[1]);
			String strLine;

			// citaj liniju po liniju i pisi na ekranu
			while ((strLine = in.readLine()) != null)
				System.out.println(strLine);

		} finally {
			socket.close();
		}
	}
}
