//: tcpServer0.java
//  SYNOPSIS:      tcpServer0 
//  DESCRIPTION:   TProgram kreira tcp soket na internet domenu
//                 povezuje ga na port 12345, slusa i prihvata 
//                 konekciju od TcpClient-a, nakon cega mu on salje
//                 ime fajla. Server otvara trayeni fajl i salje
//		    njegov sadrzaj klijentu.
/////////////////////////////////////////////////////////////////////////

import java.io.*;
import java.net.*;

public class TcpServer {
	public static final int PORT = 12345;

	public static void main(String[] args) throws IOException {

		ServerSocket serverSocket = new ServerSocket(PORT);
		BufferedReader fileReader = null;
		BufferedReader in = null;
		PrintWriter out = null;

		while (true) {
			// Blokira se do klijentskog zahteva za konekcijom 
			Socket socket = serverSocket.accept();

			try {
				in = new BufferedReader(new InputStreamReader(socket.getInputStream()));

				out = new PrintWriter(new BufferedWriter(
						new OutputStreamWriter(socket.getOutputStream())), true);

				// uzmi ime fajla
				String strLine = in.readLine();

				// Otvori fajl kao BufferedReader
				fileReader = new BufferedReader(new InputStreamReader(
						new DataInputStream(new FileInputStream(strLine))));
				
				// Citaj fajl liniju po liniju i salji na soket
				while ((strLine = fileReader.readLine()) != null)
					out.println(strLine);

			} finally {
				socket.close();
				fileReader.close();
			}
		} // while true
	}
}
