/* Klijentski program za server fajlova */

#include <sys/types.h> 
#include <sys/socket.h> 
#include <netinet/in.h> 
#include <netdb.h> 
#include <stdio.h>
#include <string.h>

#define SERVER_PORT 12345       /* proizvoljno, ali isto za klijent i server */  
#define BUF_SIZE 4096                          /* velicina bloka za transfer */ 

int main(int argc, char **argv) 
{ 
 int c, s, bytes; 
 char buf[BUF_SIZE];                           /* bafer za fajl koji se prima */ 
 struct hostent *h;                     /* struktura za informacije o serveru */ 
 struct sockaddr_in channel;                   /* struktura za IP adrese */ 

 if (argc != 3) fatal("Usage: client server-name file-name"); 
 h = gethostbyname(argv[1]);                   /* pretrazi adresu servera */ 
 if (!h) fatal("gethostbyname failed"); 

 s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP); 
 if (s <0) fatal("socket"); 
 memset(&channel, 0, sizeof(channel)); 
 channel.sin_family= AF_INET; 
 memcpy(&channel.sin_addr.s_addr, h->h_addr, h->h_length); 
 channel.sin_port= htons(SERVER_PORT); 

 c = connect(s, (struct sockaddr *) &channel, sizeof(channel)); 
 if (c < 0) fatal("connect failed"); 

 /* Konekcija je uspostavljena. Posalji ime fajla sa nulom na kraju. */ 
 write(s, argv[2], strlen(argv[2])+1); 

/* Uzmi sadrzaj fajla sa soketa i ispisi ga na stdout */ 
 while (1) { 
     bytes = read(s, buf, BUF_SIZE);             /* citaj iz soketa */ 
     if (bytes <= 0) exit(0);                    /* proveri da li je kraj */ 
     write(1, buf, bytes);                       /* pisi na stdout (ekran) */ 
 } 
} 

fatal(char *string) 
{ 
	printf("%s\n", string); 
	exit(1); 
} 
