#include <sys/types.h>                  		/* Serverski kod */ 
#include <sys/fcntl.h> 
#include <sys/socket.h> 
#include <netinet/in.h> 
#include <netdb.h> 
#include <stdio.h>
#include <string.h>

#define SERVER_PORT 12345       /* proizvoljno, ali isto za klijent i server */ 
#define BUF_SIZE 4096                         /* velicina bloka */ 
#define QUEUE_SIZE 10 

int main(int argc, char *argv[]) 
{ 
 int s, b, l, fd, sa, bytes, on = 1; 
 char buf[BUF_SIZE];                          /* bafer za fajl koji se salje */ 
 struct sockaddr_in channel;                  /* sadrzi IP adresu */ 

 /* Napravi adresnu strukturu i povezi je sa soketom. */ 
 memset(&channel, 0, sizeof(channel));        /* nulovanje channel-a */ 
 channel.sin_family = AF_INET; 
 channel.sin_addr.s_addr = htonl(INADDR_ANY); 
 channel.sin_port = htons(SERVER_PORT); 

 /* Pasivno otvaranje soketa. Cekanje konekcije. */ 
 s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);   /* pravljenje soketa */ 
 if (s < 0) fatal("socket failed"); 
 setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char *) &on, sizeof(on)); 

 b = bind(s, (struct sockaddr *) &channel, sizeof(channel)); 
 if (b < 0) fatal("bind failed"); 

 l = listen(s, QUEUE_SIZE);          /* specificiranje velicine reda cekanja */ 
 if (l < 0) fatal("listen failed"); 

 /* Soket je napravljen, cekaj konekciju */ 
 while (1) { 
     sa = accept(s, 0, 0);                  /* blokiranje do poziva klijenta */ 
     if (sa < 0) fatal("accept failed"); 

     read(sa, buf, BUF_SIZE);               /* citanje imena fajla iz soketa */ 

     /* Get and return the file. */ 
     fd = open(buf, O_RDONLY);              /* otvori fajl i posalji klijentu */ 
     if (fd < 0) fatal("open failed"); 
  
     while (1) { 
          bytes = read(fd, buf, BUF_SIZE); /* citanje iz fajla */ 
          if (bytes <= 0) break;            /* ispitivanje za kraj fajla */ 
          write(sa, buf, bytes);            /* pisanje bajtova u soket */ 
     } 
     close(fd);                             /* zatvori fajl */ 
     close(sa);                             /* zatvori konekciju */ 
 } 
}

fatal(char *string) 
{ 
	printf("%s\n", string); 
	exit(1); 
}
