import java.net.*;
import java.io.*;
import java.util.*;

public class ChatClient {

	// Port je konstanta, mora da bude isti za klijent i server
	private static final int PORT = 12345;

	public static void main(String[] args) throws IOException {

		PrintWriter out = null;
		BufferedReader in = null;

		if (args.length != 1) {
			System.out.println("Koriscenje: java ChatClient hostname");
			System.exit(0);
		}

		// Konekcija na dati host
		InetAddress address = InetAddress.getByName(args[0]);

		// Pokusaj konekcije na ChatServer
		Socket socket = new Socket(address, PORT);

		try {
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(
					socket.getOutputStream())), true);

			in = new BufferedReader(new InputStreamReader(socket
					.getInputStream()));

			Scanner sc = new Scanner(System.in);
			String fromServer;
			String fromUser;

			while ((fromServer = in.readLine()) != null) {
				System.out.println("Server: " + fromServer);
				if (fromServer.equals("Cao."))
					break;

				fromUser = sc.nextLine();

				if (fromUser != null) {
					System.out.println("Client: " + fromUser);
					out.println(fromUser);
				}
			}

		} finally {
			socket.close();
			in.close();
			out.close();
		}
	}
}
