import java.io.*;
import java.net.*;
import java.util.Scanner;

public class ChatServer {
	public static final int PORT = 12345;

	public static void main(String[] args) throws IOException {

		ServerSocket serverSocket = new ServerSocket(PORT);
		BufferedReader in = null;
		PrintWriter out = null;

		while (true) {
			// Blokira se do klijentskog zahteva za konekcijom
			Socket socket = serverSocket.accept();

			try {
				in = new BufferedReader(new InputStreamReader(socket
						.getInputStream()));

				out = new PrintWriter(new BufferedWriter(
						new OutputStreamWriter(socket.getOutputStream())), true);

				Scanner sc = new Scanner(System.in);
				String fromClient;
				String fromUser;

				// Inicira komunikaciju slanjem prve poruke
				out.println("Server aktivan");

				while ((fromClient = in.readLine()) != null) {
					System.out.println("Client: " + fromClient);
					if (fromClient.equals("Cao."))
						break;

					fromUser = sc.nextLine();

					if (fromUser != null) {
						System.out.println("Server: " + fromUser);
						out.println(fromUser);
					}
				}

			} finally {
				socket.close();
				out.close();
				in.close();
			}
		} // while true
	}
}
