(deftemplate temperatura
0 40 C
(
	(hladno (0 1) (10 0) )
	(sveze (PI 4 14))
	(prijatno (PI 4 22))
	(toplo (PI 2 28))
	(vruce (S 30 40))
)
)

(deftemplate brzina_motora
0 100 kmh
(
	(stop (0 0))
	(sporo (0 0) (20 1) (40 0))
	(srednje (35 0) (50 1) (65 0))
	(brzo (50 0) (70 1) (90 0))
	(veoma-brzo (70 0) (100 1))
)
)

(deftemplate ventilacija 
 (slot brzina (type FUZZY-VALUE brzina_motora))
 (slot stanje (allowed-values on off)(default off))
 )
 
(deffacts c
	(ventilacija (brzina stop))
)
(defrule p1
	(temperatura hladno)
	=>
	(assert (Sistem za ventilaciju ce ostati ukljucen))
	)
(defrule p2
	(temperatura sveze)
	=>
	(assert (ventilacija (brzina sporo)(stanje on)))
	)
(defrule p3
	(temperatura prijatno)
	=>
	(assert (ventilacija (brzina srednje)(stanje on)))
)
(defrule p4
	(temperatura toplo)
	=>
	(assert (ventilacija (brzina brzo)(stanje on)))
	)
(defrule p5
	(temperatura vruce)
	=>
	(assert (ventilacija (brzina veoma-brzo)(stanje on)))
	)
	
(deffunction pitanje (?pitanje)
 (printout t ?pitanje crlf)
 (bind ?odgovor (read))
 (if (or (eq ?odgovor da) (eq ?odgovor DA))
	then (return TRUE)
	else (return FALSE))
)

(deffunction unos_temperature (?bool)
	(if (eq ?bool TRUE)
	then (printout t "kolika je temp?" crlf)
	(bind ?odgovor (read))
	(assert (temperatura (PI 2 ?odgovor)))
	else
	(printout t "da li je u sobi hladno, sveze, prijatno,
	toplo, vruce? " crlf)
	(bind ?odgovor (read))
	(assert-string (str-cat "(temperatura " ?odgovor ")"))
	;(assert-string (format nil "(temperatura %s)" ?odgovor)) - drugi nacin
	;(assert (temperatura ?odgovor)) - greska
	)
	)
(defrule p6
 =>
 (unos_temperature (pitanje "Da li imas termometar?" ))
)
	

