;
; ES za izbor optimalne teme za diplomski/master rad
;

(deftemplate tema
(slot naziv)
(slot mentor)
(multislot oblasti)
(slot zauzeta (allowed-values DA NE))
(slot CF (default 0))
)

(deffacts cinjenice
(tema (naziv "Koriscenje Kinect tehnologije u nastavi matematike i informatike") (mentor Boban) (oblasti programiranje matematika bazePodataka nastava) (zauzeta DA))
(tema (naziv "Portovanje WoBinGO servisa na OpenStack sistem") (mentor Milos) (oblasti programiranje web problemi) (zauzeta NE))
(tema (naziv "Razvoj sistema za tagovanje fajlova na ownCloud platformi") (mentor Milos) (oblasti programiranje web) (zauzeta NE))
(tema (naziv "MathML") (mentor Vladimir) (oblasti programiranje matematika problemi) (zauzeta NE))
(faza pocetak)
(promena-faza pocetak zauzeteTeme)
(promena-faza zauzeteTeme unos)
(promena-faza unos bodujOblasti)
(promena-faza bodujOblasti izvrsiBodovanjePoOblastima)
(promena-faza izvrsiBodovanjePoOblastima nadjiMax)
(sve-oblasti "")
)

;upisi nove oblasi i vrati ih
(deffunction upisiNoveOblasti
(?sveOblasti $?noveOblasti)


(loop-for-count (?i 1 (length$ $?noveOblasti)) do
(if (eq (str-index (nth$ ?i $?noveOblasti) ?sveOblasti) FALSE) then (bind ?sveOblasti (str-cat ?sveOblasti " " (nth$ ?i $?noveOblasti))))
)

(return ?sveOblasti)

)

;vrati TRUE ako postoji neka oblast koja jos uvek nije upisana
(deffunction neupisanaOblast
(?sveOblasti $?noveOblasti)


(loop-for-count (?i 1 (length$ $?noveOblasti)) do
(if (eq (str-index (nth$ ?i $?noveOblasti) ?sveOblasti) FALSE) then (return TRUE))
)

(return FALSE)

)

;vrati broj clanova preseka dva skupa
(deffunction preklapanja
(?len $?skup)

(bind $?skup1 (subseq$ $?skup 1 ?len))
(bind $?skup2 (subseq$ $?skup (+ 1 ?len) (length$ $?skup)))

(bind ?brojac 0)

(loop-for-count (?i ?len) do 
	(if (member$ (nth$ ?i $?skup1) $?skup2) then (bind ?brojac (+ 1 ?brojac)))

)

(return ?brojac)

)


(defrule kontrola-toka
	(declare (salience -10))
	?f <- (faza ?faza)
	(promena-faza ?faza ?novaFaza)
	=>
	(retract ?f)
	(assert (faza ?novaFaza))
)

(defrule zauzeteTeme
	(faza zauzeteTeme)
	(not (tema (zauzeta NE)))
	=>
	(printout t "Zakasnili ste. Sve teme su zauzete" crlf)
	(halt)
)

(defrule pocetak
	(faza pocetak)
	?f <- (sve-oblasti ?s)
	(tema (oblasti $?oblasti))
	(test (neupisanaOblast ?s $?oblasti))
	=>
	(bind ?rezultat (upisiNoveOblasti ?s $?oblasti))
	(retract ?f)
	(assert (sve-oblasti ?rezultat ))
)

(defrule unos
	(faza unos)
	(sve-oblasti ?s)
	=>
	(printout t "Unesite preferirane mentore" crlf)
	(assert (mentori (explode$ (readline))))
	(printout t "Ponudjene oblasti su: " ?s crlf)
	(printout t "Unesite preferirane oblasti" crlf)
	(assert (oblasti (explode$ (readline)))) 
)

(defrule bodujOblasti
	(faza bodujOblasti)
	(oblasti $?oblasti)
	(mentori $?mentori)
	?f <- (tema (mentor ?mentor)(oblasti $?oblastiTeme) (CF ?cf)(zauzeta NE))
	(test (member$ ?mentor $?mentori))
	=>
	(bind ?broj (preklapanja (length$ $?oblasti) $?oblasti $?oblastiTeme))
	(bind ?broj (+ ?cf ?broj))
	(assert (boduj ?f ?broj))
)

(defrule izvrsiBodovanje
	(faza izvrsiBodovanjePoOblastima)
	?f1 <- (boduj ?f ?broj)
	=>
	(modify ?f (CF ?broj))
	(retract ?f1)
)

(defrule nadjiMax
	(faza nadjiMax)
	(mentori $?mentori)
	(tema (naziv ?naziv)(mentor ?mentor)(CF ?cf)(zauzeta NE))
	(not (tema (CF ?cf1&: (< ?cf ?cf1))(zauzeta NE)))
	(test (member$ ?mentor $?mentori))
	=>
	(printout t "Najbolja tema za vas je " ?naziv ", kod profesora " ?mentor "a (CF " ?cf  ")." crlf)
)

 