(defclass STUDENT
	(is-a USER)
	(slot ime)
	(slot indeks)
	(multislot polozeni-ispiti)
	(multislot ocene (type INTEGER))
)

(defclass BUDZETSKI-STUDENT
	(is-a STUDENT)
	(slot cena-prijave (access read-only) (default 200))
)

(defclass SAMOFINANSIRAJUCI-STUDENT 
	(is-a STUDENT)
	(slot cena-prijave (access read-only) (default 1000))
)

(defclass ISPIT 
	(is-a USER)
	(slot naziv)
	(slot broj-polozenih (default 0) (storage shared) )
)

(deffunction uvecajBrojPolozenihIspita (?ispit)
	(if (any-instancep ((?i ISPIT)) (eq (instance-name ?i) ?ispit))
		then
			(send ?ispit put-broj-polozenih (+ (send ?ispit get-broj-polozenih) 1))
	)
)

(deffunction izracunajProsecneOcene ()
	(do-for-all-instances ((?s STUDENT)) TRUE

		(if (eq (length$ ?s:polozeni-ispiti) 0)
			then
				(printout t "Student " (instance-name ?s) " nema polozenih ispita!" crlf)
			else
				(bind ?suma 0)
				(bind $?ocene (send ?s get-ocene))
				(loop-for-count (?i 1 (length$ $?ocene)) 
					(bind ?suma (+ ?suma (nth$ ?i $?ocene)))
				)
				(bind ?prosek (/ ?suma (length$ $?ocene)))
				(printout t "Student " (send ?s get-ime) " ima prosek " ?prosek crlf)
		)	
	)
)

(defmessage-handler STUDENT upisi-ocenu (?ispit ?ocena)
	(if (member$ ?ispit (send ?self get-polozeni-ispiti))
		then
			(printout t "Student je vec polozio taj ispit!" crlf)
			(return)
	)

	(while (or (eq (numberp ?ocena) FALSE)  (< ?ocena 5) (> ?ocena 10)) do
		(printout t "Unesite ocenu u odgovarajucem formatu (5-10)" crlf)
		(bind ?ocena (read))
	)
	
	(printout t "Troskovi prijave ispita su " (send ?self get-cena-prijave) crlf crlf)

	(if (> ?ocena 5)
		then
			(bind ?self:polozeni-ispiti ?self:polozeni-ispiti ?ispit)
			(bind ?self:ocene ?self:ocene ?ocena)
			(uvecajBrojPolozenihIspita ?ispit)
	)
)

(defrule p1
	?i <- (object (is-a ISPIT))
	?s <- (object (is-a STUDENT))
	(test (not (member$ (instance-name ?i) (send ?s get-polozeni-ispiti))))
		=>
	(printout t "Unesite ocenu za studenta " (send ?s get-ime) " za ispit " (send ?i get-naziv) crlf)
	(bind ?ocena (read))
	(send ?s upisi-ocenu (instance-name ?i) ?ocena)	
)

(defrule p2
	(declare (salience -10))
		=>
	(printout t "Prosecne ocene studenata: " crlf)
	(izracunajProsecneOcene)
)

(definstances bla
	(i1 of ISPIT (naziv IS1))
	(i2 of ISPIT (naziv OS1))
	(i3 of ISPIT (naziv OS2))
	(s1 of BUDZETSKI-STUDENT (ime Pera) (indeks 23-2001) (polozeni-ispiti [i1] [i2]))
	(s2 of SAMOFINANSIRAJUCI-STUDENT (ime Laza) (indeks 3-2011) (polozeni-ispiti [i1]))
)