(defclass KOMPANIJA
(is-a USER)
(multislot naziv (default ?NONE))
(multislot zaposleni)
(slot lokacija (default ?NONE))
(slot plata_po_koeficijentu (default ?NONE) (type NUMBER))
(slot slobodna_radna_mesta (type INTEGER)(range 0 1000))
)

(defclass ZAPOSLENI
(is-a USER)
(role abstract)
(multislot ime (default N N))
(slot mesto (default ?NONE))
(slot koeficijent (default ?NONE))
)

(defclass DIREKTOR
(is-a ZAPOSLENI)
(role concrete)
(slot sektor)
(pattern-match reactive) ;opisati
)

(defclass CUVAR
(is-a ZAPOSLENI)
(role concrete)
(slot smena (allowed-values prva druga treca))
)

(definstances objekti
(k1 of KOMPANIJA (naziv fiat) (lokacija KG) (plata_po_koeficijentu 10000) (slobodna_radna_mesta 15))
(k2 of KOMPANIJA (naziv coca-cola) (lokacija BG) (plata_po_koeficijentu 20000) (slobodna_radna_mesta 2))
(d1 of DIREKTOR (ime Pera Peric) (mesto KG) (koeficijent 1.6) (sektor racunovodstvo))
(d2 of DIREKTOR (ime Sima Simic)  (mesto BG) (koeficijent 1.5) (sektor marketing))
(c1 of CUVAR (ime Sima Peric) (mesto BG) (koeficijent 0.9) (smena treca))
(c2 of CUVAR (ime Kosta Maric) (mesto KG) (koeficijent 0.5) (smena druga))
(error1 of CUVAR (ime Los Unos) (mesto KV) (koeficijent 1))
)

(deffunction nadji-kompaniju (?mesto)
	(return (find-instance ((?k KOMPANIJA)) (and (> ?k:slobodna_radna_mesta 0) (eq ?k:lokacija ?mesto))))
)

(deffunction listaj-plate (?naziv)

	(do-for-all-instances ((?k KOMPANIJA)(?z ZAPOSLENI)) (and (eq ?naziv (implode$ ?k:naziv)) (member$ ?z ?k:zaposleni)) 
		(printout t "Zaposleni " (implode$ ?z:ime) " ima platu: " (* ?z:koeficijent ?k:plata_po_koeficijentu) " dinara." crlf)
	)

)

(defmessage-handler ZAPOSLENI init around()
	(bind $?komp (nadji-kompaniju (send ?self get-mesto)))

	(if (eq 0 (length$ $?komp)) 
	then 
		(printout t "Nema slobodnih radnih mesta u mestu " ?self:mesto "." crlf)
		(return)
	)

	(call-next-handler)

	(bind ?k (nth$ 1 $?komp))

	(send ?k put-zaposleni (send ?k get-zaposleni) (instance-name ?self))
	(send ?k put-slobodna_radna_mesta (- (send ?k get-slobodna_radna_mesta) 1))
)


(defrule p1
?k <- (object (is-a KOMPANIJA) (zaposleni $?z) (naziv $?n))
?d <- (object (is-a DIREKTOR) (sektor ?s) (ime $?i))
(test (member$ (instance-name ?d) $?z))
=>
(printout t "Direktor " (implode$ ?i) " (" ?s ") u kompaniji " (implode$ ?n) " ima platu  " (* (send ?k get-plata_po_koeficijentu) (send ?d get-koeficijent)) " din." crlf)
)

(defrule p2
(listaj ?naziv)
=>
(listaj-plate ?naziv)
)
