(deftemplate film
(multislot naziv)
(multislot zanrovi)
(slot imdb_ocena (type NUMBER)(range 0 10))
(slot CF (default 0))
)

(deffacts cinjenice
(film (naziv The Imitation Game)  (imdb_ocena 8.1) (zanrovi Drama Biografija Triler))
(film (naziv Interstellar) (imdb_ocena 8.7) (zanrovi Avantura Sci-Fi))
(film (naziv Mad Max: Fury Road) (imdb_ocena 8.6) (zanrovi Akcija Avantura Sci-Fi))
(film (naziv The Drop)  (imdb_ocena 7.1) (zanrovi Drama Kriminal))
(film (naziv Child 44)  (imdb_ocena 8.1) (zanrovi Drama Triler))
(film (naziv The Game) (imdb_ocena 7.8) (zanrovi Drama Misterija Triler))
(faza prodji-sve)
(promena-faza prodji-sve upisi)
(promena-faza upisi unos)
(promena-faza unos bodujFilmove)
(promena-faza bodujFilmove izvrsiBodovanjePoFilmovima)
(promena-faza izvrsiBodovanjePoFilmovima nadjiMax)
(svi-zanrovi "")
)

(deffunction provera (?zanr $?zanrovi)

	(bind ?len (length$ $?zanrovi))
	(loop-for-count (?i 1 ?len) do
		(if (neq FALSE (str-index (nth$ ?i $?zanrovi) ?zanr)) then
			(return TRUE)
		)
	)

	(return FALSE)
)

(deffunction preklapanja(?len $?skup)

	(bind $?skup1 (subseq$ $?skup 1 ?len))
	(bind $?skup2 (subseq$ $?skup (+ 1 ?len) (length$ $?skup)))

	(bind ?brojac 0)

	(loop-for-count (?i ?len) do 
		(if (member$ (nth$ ?i $?skup1) $?skup2) then (bind ?brojac (+ 1 ?brojac)))
	)

	(return ?brojac)
)

(defrule kontrola-toka
	(declare (salience -10))
	?f <- (faza ?faza)
	(promena-faza ?faza ?novaFaza)
	=>
	(retract ?f)
	(assert (faza ?novaFaza))
)


(defrule pocetak
	(faza prodji-sve)
	(film (zanrovi $?zanrovi))
	=>
	(assert (dodaj-zanr ?zanrovi))
)

(defrule upisi
	(faza upisi)
	?f <- (dodaj-zanr $?zanrovi)
	?f1 <- (svi-zanrovi ?z)
	=>
	(retract ?f)
	(retract ?f1)
	(bind ?sviZanrovi (str-cat ?z (implode$ ?zanrovi) " " ))
	(assert (svi-zanrovi ?sviZanrovi))
)


(defrule unos
	(faza unos)
	(svi-zanrovi ?z)
	=>
	(printout t "Unesite zeljene filmske zanrove:" crlf)
	(bind $?zanrovi (explode$ (readline)))

	(while (eq FALSE (provera ?z $?zanrovi)) do
		(printout t "Nijedan od unetih filmske zanrova ne postoji u bazi filmova." crlf)
		(printout t "Unesite filmske zeljene zanrove:" crlf)
		(bind $?zanrovi (explode$ (readline)))
	)

	(assert (zanrovi $?zanrovi)) 
)


(defrule bodujFilmove
	(faza bodujFilmove)
	(zanrovi $?zeljeni-zanrovi)
	?f <- (film (zanrovi $?zanrovi) (CF ?cf))
	=>
	(bind ?broj (preklapanja (length$ $?zeljeni-zanrovi) $?zeljeni-zanrovi $?zanrovi))
	(assert (boduj ?f ?broj))
)

(defrule izvrsiBodovanje
	(faza izvrsiBodovanjePoFilmovima)
	?f1 <- (boduj ?f ?broj)
	=>
	(modify ?f (CF ?broj))
	(retract ?f1)
)

(defrule nadjiMax
	(faza nadjiMax)
	(film (naziv $?naziv)(CF ?cf) (imdb_ocena ?i))
	(not (film (CF ?cf1&: (< ?cf ?cf1))))
	(not (film (CF ?cf)(imdb_ocena ?i1&: (< ?i ?i1))));
	=>
	(printout t "Preporuceni film za vas je " (implode$ ?naziv) " (imdb ocena:" ?i ")."  crlf)
)



