(deftemplate DNEVNA_SVETLOST
0 1 jacina
(
(slaba (0 1) (0.38 0 ))
(srednja (0.4 0 ) (0.5 1 ) (0.62 0 ))
(jaka (0.62 0 ) (1 1))
))

(deftemplate VESTACKA_SVETLOST
0 2 jacina
(
(slaba (Z 0 0.5))
(srednja (PI 0.5 1))
(jaka (S 1.5 2))
)
)

(deftemplate dnevna_svetlost
(slot jacina (type FUZZY-VALUE DNEVNA_SVETLOST)))

(deftemplate vestacka_svetlost
(slot jacina (type FUZZY-VALUE VESTACKA_SVETLOST))
)


(defrule crtanje1
=>
(plot-fuzzy-value t "*+." nil nil (create-fuzzy-value DNEVNA_SVETLOST slaba)
								  (create-fuzzy-value DNEVNA_SVETLOST srednja)	
								  (create-fuzzy-value DNEVNA_SVETLOST jaka))
)

(defrule crtanje2
=>
(plot-fuzzy-value t "*+." nil nil (create-fuzzy-value VESTACKA_SVETLOST slaba)
								  (create-fuzzy-value VESTACKA_SVETLOST srednja)	
								  (create-fuzzy-value VESTACKA_SVETLOST jaka))
)


(defrule p1 
(dnevna_svetlost (jacina slaba))
=>
(assert (vestacka_svetlost (jacina jaka)))

)

(defrule p2
(dnevna_svetlost (jacina srednja))
=>
(assert (vestacka_svetlost (jacina srednja)))
)

(defrule p3
(dnevna_svetlost (jacina jaka))
=>
(assert (vestacka_svetlost (jacina slaba)))
)

(defrule unos
=>
(printout t "Unesi jacinu dvevne svetlosti:" crlf)
(bind ?s (read))
(assert (svetlost ?s))
)

(defrule provera
?f <- (svetlost ?s)
(test (numberp ?s))
=>
(assert (dnevna_svetlost (jacina (PI 0.02 ?s))))
(retract ?f))

(defrule provera1
?f <- (svetlost ?s)
(test (not (numberp ?s)))
=>
(assert-string (format nil "(dnevna_svetlost (jacina %s))" ?s))
(retract ?f))


(defrule defuzzify
(vestacka_svetlost (jacina ?j))
=>
(printout t "Jacina vestacke svetlosti treba biti: " (maximum-defuzzify ?j) " (maximum)"  crlf)
(printout t "Jacina vestacke svetlosti treba biti: " (moment-defuzzify ?j) " (moment)"  crlf))
