use magacin
go

create procedure sp_premestaj_paketa
(
@idPaketa int
)
as
begin
	declare @zapremina decimal(8,2)

	begin try
		set transaction isolation level
		repeatable read
		begin tran t2
		select @zapremina=zapremina
		from paketi
		where id=@idPaketa

		declare @idTrenSektora int, @idSledSektora int

		select @idTrenSektora=id
		from sektori
		where idPaketa=@idPaketa

		select top 1 @idSledSektora=id from sektori
		where idPaketa is NULL and zapremina>=@zapremina
		order by zapremina asc

		if @idSledSektora is not null
		begin
			declare @vreme datetime
			set @vreme=GETDATE()

			update sektori
			set idPaketa=NULL
			where id=@idTrenSektora

			update sektori
			set idPaketa=@idPaketa
			where id=@idSledSektora

			update istorija
			set vremeKraj=@vreme
			where idPaketa=@idPaketa and vremeKraj is NULL

			insert into istorija(idSektora, idPaketa, vremePocetak, vremeKraj)
			values(@idSledSektora, @idPaketa, @vreme, NULL)

			commit tran t2

		end
		else
		begin
			rollback tran t2
		end
	end try
	begin catch
		rollback tran t2
		select ERROR_MESSAGE() as greska
	end catch
end

-- slicno kao i za prijem_paketa
-- ako stavimo read committed
-- i pokrenemo dva premestaja u isti sektor
-- ili premestaj i prijem u isti sektor
-- ubacicemo oba paketa u isti sektor, a ostace samo jedan
-- istorija ce da zabelezi oba

-- sa repeatable read
-- dolazi do deadlock-a nad sektorom