use magacin
go

create procedure sp_prijem_paketa
(
	@zapremina decimal(8,2)
)
as
begin
	begin try
		set transaction isolation level
		repeatable read

		begin tran t1
		declare @idSektora int

		select top 1 @idSektora=id from sektori
		where idPaketa is NULL and zapremina>=@zapremina
		order by zapremina asc

		if @idSektora is not null
		begin
			declare @vreme datetime
			set @vreme=GETDATE()

			insert into paketi(zapremina, vremeUlaska, vremeIzlaska)
			values(@zapremina, @vreme, NULL)

			declare @idPaketa int

			select @idPaketa=id
			from paketi
			where vremeUlaska=@vreme

			update sektori set idPaketa=@idPaketa
			where id=@idSektora

			insert into istorija(idSektora, idPaketa, vremePocetak, vremeKraj)
			values(@idSektora, @idPaketa, @vreme, NULL)

			commit tran t1
		end
		else
		begin
			rollback tran t1
		end
		
	end try
	begin catch
		rollback tran t1
		select ERROR_MESSAGE() as greska;
	end catch
end
go

-- ako stavimo read committed
-- i pokrenemo dva prijema istovremeno
-- ubacimo dva paketa zapremine 12
-- oba procitaju tabelu sektori i odaberu sektor 12
-- oba pokusaju da azuriraju sektor 1, prvi uspe, drugi se blokira (X lock)
-- prvi zavrsi transakciju, drugi se odblokira i azurira sektor 1
-- sektor 1 sadrzi drugi paket, prvi paket nije ni u jednom sektoru
-- a pise da je usao u magacin, istorija cuva oba paketa u sektoru 1

-- ako stavimo repeatable read
-- S lock iz top upita se produzava
-- ako pokusamo dva prijema u isti sektor
-- doci ce do deadlock-a

-- cak i ako probamo dva prijema razlicite zapremine (12 i 14)
-- ako se select top prvo izvrsi za 12
-- ostaje S lock nad svim vecim zapreminama
-- i opet dolazi do deadlock-a


