use magacin
go

create procedure sp_slanje_paketa
(
@idPaketa int
)
as
begin
	declare @vreme datetime
	set @vreme=GETDATE()
	begin try
		begin tran t3
		update istorija
		set vremeKraj=@vreme
		where idPaketa=@idPaketa and vremeKraj is NULL

		update sektori
		set idPaketa=NULL
		where idPaketa=@idPaketa

		update paketi
		set vremeIzlaska=@vreme
		where id=@idPaketa
		commit tran t3
	end try
	begin catch
		rollback tran t3
		select ERROR_MESSAGE() as greska
	end catch
end

-- nebitan nivo izolacije, sve operacije postavljaju X lokove
-- moze i read uncommitted, stavili smo default-ni read committed
-- nijedna druga transakcija koja radi sa sektorima ne sme da bude read uncommitted
-- da ne procita odavde da je sektor oslobodjen, a onda se ova transakacija ponisti
