use bp2
go

create procedure sp_klijentiKasnjenje
as
begin
begin try
	set transaction isolation level 
	read committed
	--moze doci do prljavog citanja 
	--ako transakcija t2 (sp_zavrsenTransfer) promeni realizovaniDatumPrimanja,
	--zatim ova transakcija t4 ne ubroji taj paket u one koji kasne
	--a transakcija t2 se rollback-uje
	begin tran t4

	declare @sdatum datetime

	set @sdatum  = GETDATE()

	select sifra, sifraPosiljaoca, sifraPrimaoca, DATEDIFF(DAY,zeljeniDatumPrimanja, @sdatum) as brDana
	from paketi
	where zeljeniDatumPrimanja < @sdatum and realizovaniDatumPrimanja is null
	
	commit tran t4
end try
begin catch
	print ERROR_MESSAGE()
	rollback tran t4
end catch
end