USE [bp2]
GO
/****** Object:  StoredProcedure [dbo].[sp_lokacijaPaketa]    Script Date: 2/8/2014 10:18:13 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER procedure [dbo].[sp_lokacijaPaketa](
	@sifraPaketa int
)
as
begin
begin try
	set deadlock_priority low 
	-- pri konkurentnom izvrsavanju sa sp_zavrsenTransfer moze doci do deadlock-a
	-- biramo ovu transakciju kao zrtvu deadlock-a
	-- jer su naredbe modifikacije bitnije od naredbi citanja
	-- i u zadatku je naglaseno da se insert i update upiti redji u odnosu na select upite
	set transaction isolation level
	repeatable read
	-- pri konkurentnom izvrsavanju sa sp_zavrsenTransfer moze doci do neponovljenog citanja
	-- npr. ova transakcija (t3) procita tabelu paketi
	-- transakcija u sp_zavrsenTransfer promeni i tabelu paketi i tabelu transferi
	-- t3 zatim procita tabelu transferi sa promenjenim vrednostima
	-- dolazi do pogresnog prikaza rezultata ovog upita
	begin tran t3

    declare @stigao int
	select @stigao = count(*) from paketi
	    where sifra = @sifraPaketa and realizovaniDatumPrimanja is null

	waitfor delay '00:00:10'
	
	if @stigao = 1
	begin
	    select p.sifra as paket,p1.naziv as krece,t1.naziv as trenutnoOd,t2.naziv as trenutnoKa,p2.naziv as stize
		   from  paketi p join
		      transferi t on p.sifra = t.sifraPaketa
			     join klijenti k1 on p.sifraPosiljaoca = k1.sifra
				    join poste p1 on k1.sifraPoste = p1.sifra

                 join poste t1 on t.sifraPosteSlanja = t1.sifra
				 join poste t2 on t.sifraPostePrimanja = t2.sifra

				 join klijenti k2 on p.sifraPrimaoca = k2.sifra
				    join poste p2 on k2.sifraPoste = p2.sifra
			     where p.sifra = @sifraPaketa and t.datumPrimanja is null  
	end
	else
	begin
	   select p.sifra,p1.naziv,NULL,NULL,p2.naziv
		   from  paketi p 
		 
			     join klijenti k1 on p.sifraPosiljaoca = k1.sifra
				    join poste p1 on k1.sifraPoste = p1.sifra

				join klijenti k2 on p.sifraPrimaoca = k2.sifra
				    join poste p2 on k2.sifraPoste = p2.sifra

			     where p.sifra = @sifraPaketa
	end
	commit tran t3
end try
begin catch
	print 'Greska!'
	print ERROR_MESSAGE()
	rollback tran t3
end catch
end

