
--------- JOIN -------------------

-- Postoje 3 vrste join-a

-- 1) Nested loops join - Radi kao dvostruka petlja. 
-- Za svaku vrstu iz jedne tabele se pretrazuju sve vrste iz druge tabele.

-- 2) Hash join - Od podataka iz jedne tabele se napravi hash tabela.
-- Izgradnja hash tabele traje dugo, ali je nakon toga pretraga trenutna.
-- Za svaku vrstu iz druge tabele, racunanjem hash funkcije odmah se nalazi njen parnjak iz prve tabele.

-- 3) Merge join - Da bi mogao da se izvede merge join, potrebno je da obe kolone po kojima se vrsi 
-- spajanje budu sortirane. Zatim se ide redom kroz jednu i drugu tabelu i spajaju se odgovarajuce vrste.


-- Primer za nested loops - Dekartov proizvod
select *
from person, statusi
-- Nested loops (inner join) 96%

-- SQL server ce uglavnom izbegavati upotrebu nested loops join-a, osim za veoma mali broj podataka
select *
from person p join statusi s
on p.BusinessEntityID = s.idOsobe
where p.firstname = 'Martin' and s.datum = '2013-12-18'
-- procena je da ce upit vratit oko 7 vrsta
-- za tako mali broj vrsta nije problem upotrebiti dvostruku petlju (nested loops) za join
-- cak je i najbrze resenje

-- Ako upit vraca vecu kolicinu podataka, SQL Server racuna sta je brze:
-- da li da izgradi hash tabelu (hash join), 
-- ili da sortira kolone po kojima se tabele spajaju (merge join)

-- Primer: Za sve statuse prikazati njihov tekst i ime i prezime osobe koja je objavila status.

select firstname, lastname, poruka
from person p join statusi s
on p.BusinessEntityID = s.idOsobe

-- Prva varijanta - ni p.BusinessEntityID ni s.idOsobe nisu sortirani

-- Izbrisati PK u tabeli Person
-- Da bi mogao da se izbrise, prvo treba ukloniti sve spoljasnje kljuceve koji referenciraju BusinessEntityID 
-- (u tabeli lajkovi kolone koLajkuje i cijiStatus, u tabeli statusi kolona idOsobe)

alter table person
drop constraint PK_Person_BusinessEntityID

select firstname, lastname, poruka
from person p join statusi s
on p.BusinessEntityID = s.idOsobe
-- bez PK u tabeli Person 1.64
-- hash match (inner join) 84% - 1.38
-- Bilo je isplativije izgraditi hash tabelu nego sortirati obe tabele.

-- Druga varijanta - p.BusinessEntityID je sortiran

-- Kreirati PK nad tabelom Person
alter table person
add constraint PK_id
primary key (BusinessEntityID)

select firstname, lastname, poruka
from person p join statusi s
on p.BusinessEntityID = s.idOsobe
-- sa PK_id nad Person 1.3
-- merge join (inner join) 6% - 0.08
-- sort (tabele statusi po idOsobe) 74% - 0.966
-- Bilo je isplativije sortirati jednu tabelu (statusi), nego graditi hash tabelu.
-- Druga tabela (Person) je vec bila sortirana po svom primarnom kljucu.
-- Kada su obe tabele sortirane po odgovarajucim kolonama, moze da se izvrsi merge join.

-- Treca varijanta - i p.BusinessEntityID i s.idOsobe su sortirani

-- Kreiramo neklasterovani indeks nad s.idOsobe koji ukljucuje i kolonu poruka, potrebnu za select
create nonclustered index idx_idosobe
on statusi(idOsobe) include (poruka)


select firstname, lastname, poruka
from person p join statusi s
on p.BusinessEntityID = s.idOsobe
-- sa PK_id i idx_idosobe 0.33
-- clustered index scan [Person] i index scan [statusi].[idx_idosobe]
-- tabela person je sortirana, indeks idx_idosobe je takodje sortiran
-- moze da se izvrsi merge join
exec sp_spaceused statusi
-- memorija: data 752KB, index 688KB

-- postignuto veliko ubrzanje upita
-- Da li je moguce smanjiti kolicinu potrosene memorije, cuvajuci isto ubrzanje?

-- Umesto neklasterovanog indeksa idx_osobe, moze se napraviti klasterovani indeks nad idOsobe.

-- Ukloniti neklasterovani indeks
drop index idx_idosobe on statusi

-- Ukloniti klasterovani PK iz tabele statusi. 
-- Pre toga ukloniti spoljasnje kljuceve koji referenciraju kolonu idOsobe (u tabeli lajkovi kolona idLajkovanogStatusa).
-- Kreirati klasterovani indeks nad idOsobe.
create clustered index cl_idosobe
on statusi(idOsobe)

-- Sada su obe tabele fizicki sortirane po kolonama spajanja

select firstname, lastname, poruka
from person p join statusi s
on p.BusinessEntityID = s.idOsobe
-- sa PK nad p.BusinessEntityID i klasterovanim nad s.idOsobe 0.34
-- merge join 
-- gotovo isto vreme izvrsavanja kao prethodni upit,
-- neznatno sporije zbog ucitavanja cele tabele statusi, umesto samo indeksa
-- ali je postignuta znacjana usteda memorije
exec sp_spaceused statusi
-- memorija: tabela 816KB, indeksi 16KB
-- Podaci u tabeli zauzimaju vise memorije nego u prethodnom primeru jer 
-- klasterovani kljuc nije vise primarni kljuc.
-- Ali je mnogo znacajnija usteda u indeksu, pa je ovaj klasterovani indeks bolji izbor.

-- NAPOMENA: Da bi merge join mogao da se primeni, neophodno je da jedna kolona spajanja bude primarni ključ.
-- Nije dovoljno da ta kolona bude samo sortirana.

