use fudbal

go

create procedure sp_izvodjenjeTransfera
(
@idFudbalera int,
@idNovogKluba int,
@vrednostTransfera int
)
as
begin
	declare @idPrethodnogKluba int
	declare @datumTransfera date
	
	select @idPrethodnogKluba=idKluba
	from fudbaleri
	where id=@idFudbalera

	set @datumTransfera = GETDATE()

	insert into transferi(idFudbalera, idPrethodnogKluba, idNovogKluba,
	vrednostTransfera, datumTransfera)
	values(@idFudbalera, @idPrethodnogKluba, @idNovogKluba,
	@vrednostTransfera, @datumTransfera)

	update fudbaleri
	set idKluba=@idNovogKluba
	where id=@idFudbalera

	update klubovi
	set budzet=budzet-@vrednostTransfera
	where id=@idNovogKluba
end

go


create procedure sp_porezKlubova
as
begin
	declare @godina int

	set @godina = YEAR(DATEADD(year,-1, getdate()))

	select k.naziv, 0.2*SUM(t.vrednostTransfera) as iznos
	from transferi t join klubovi k
	on t.idPrethodnogKluba = k.id
	where datumTransfera between DATEFROMPARTS(@godina,1,1) and DATEFROMPARTS(@godina,12,31)
	group by k.naziv
end

go

create procedure sp_porezIgraca
as
begin
    declare @godina int

	set @godina = YEAR(DATEADD(year,-1, getdate()))

	select f.ime, f.prezime, 0.1*SUM(t.vrednostTransfera) as iznos
	from transferi t join fudbaleri f
	on t.idFudbalera = f.id
	where t.datumTransfera between DATEFROMPARTS(@godina,1,1) and DATEFROMPARTS(@godina,12,31) and f.idKluba is not null
	group by f.ime, f.prezime
end

go