﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DEVSsharp;

namespace SemaforDEVS
{
    enum STANJE_SEMAFORA
    {
        CRVENO,
        CRVENO_ZUTO,
        ZUTO,
        ZELENO
    }

    class Semafor : Atomic
    {
        OutputPort crvenoPort, zutoPort, zelenoPort;
        public InputPort dugmeZaPesake;
        STANJE_SEMAFORA stanje;
        bool dugmePritisnuto;
 

        public Semafor(string name, TimeUnit unit)
            : base(name, unit)
        {
            crvenoPort = new OutputPort("crveno");
            zutoPort = new OutputPort("zuto");
            zelenoPort = new OutputPort("zeleno");
            dugmeZaPesake = new InputPort("dugme");

            AddOP(crvenoPort);
            AddOP(zutoPort);
            AddOP(zelenoPort);
            AddIP(dugmeZaPesake);

            init();
        }

        public override bool delta_x(PortValue x)
        {
            if (stanje == STANJE_SEMAFORA.ZELENO && x.port == dugmeZaPesake && TimeRemaining > 5)
            {
                dugmePritisnuto = true;
                stanje = STANJE_SEMAFORA.ZELENO;
                return true;
            }
            else return false;
        }

        public override void delta_y(ref PortValue y)
        {
            if (stanje == STANJE_SEMAFORA.CRVENO)
            {
                stanje = STANJE_SEMAFORA.CRVENO_ZUTO;
                y.Set(crvenoPort);
                y.Set(zutoPort);
            }
            else if (stanje == STANJE_SEMAFORA.CRVENO_ZUTO)
            {
                stanje = STANJE_SEMAFORA.ZELENO;
                y.Set(zelenoPort);
            }
            else if (stanje == STANJE_SEMAFORA.ZELENO)
            {
                if (dugmePritisnuto) dugmePritisnuto = false;
                stanje = STANJE_SEMAFORA.ZUTO;
                y.Set(zutoPort);
            }
            else if (stanje == STANJE_SEMAFORA.ZUTO)
            {
                stanje = STANJE_SEMAFORA.CRVENO;
                y.Set(crvenoPort);
            }

        }

        public override void init()
        {
            stanje = STANJE_SEMAFORA.CRVENO;
            dugmePritisnuto = false;
        }

        public override double tau()
        {
            switch (stanje)
            {
                case STANJE_SEMAFORA.CRVENO:
                    return 15;
                case STANJE_SEMAFORA.CRVENO_ZUTO:
                    return 1;
                case STANJE_SEMAFORA.ZUTO:
                    return 2;
                case STANJE_SEMAFORA.ZELENO:
                    {
                        if (dugmePritisnuto) return 5;
                        else return 20;
                    }
                default:
                    return double.MaxValue;
            }
        }

        public override string Get_s()
        {
            return stanje.ToString();
        }
    }
}
