﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DEVSsharp;


namespace bankomat
{
    class UpareniModel
    {
        public static Coupled SpojModele(string name)
        {
            Coupled upareni = new Coupled(name);

            InputPort karticaIn, cancelIn, pinIn, iznosIn;
            karticaIn = upareni.AddIP("kartica");
            cancelIn = upareni.AddIP("cancel");
            pinIn = upareni.AddIP("PIN");
            iznosIn = upareni.AddIP("iznos");

            OutputPort karticaOut = upareni.AddOP("karticaOut");
            OutputPort novacOut = upareni.AddOP("novac");

            BankomatModel bm = new BankomatModel("bankomat");
            Server s = new Server("ServerZaBankomat");

            upareni.AddModel(bm);
            upareni.AddModel(s);

            upareni.AddCP(karticaIn, bm.karticaIn);
            upareni.AddCP(cancelIn, bm.cancelIn);
            upareni.AddCP(pinIn, bm.pinIn);
            upareni.AddCP(iznosIn, bm.iznosIn);

            upareni.AddCP(bm.podaciOut, s.podaciIn);
            upareni.AddCP(s.rezultatOut, bm.rezultatIn);

            upareni.AddCP(bm.novacOut, novacOut);
            upareni.AddCP(bm.karticaOut, karticaOut);

            upareni.PrintCouplings();

            return upareni;
        }
    }
}
