﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DEVSsharp;

namespace bankomat
{
    enum PHASE1
    {
        ceka_podatke,
        proverava,
        azurira
    }

    public class Server : Atomic
    {
        public InputPort podaciIn;
        public OutputPort rezultatOut;
        PHASE1 phase;
        Podaci p;

        public Server(string name)
            : base(name, TimeUnit.Sec)
        {
            podaciIn = AddIP("podaci");
            rezultatOut = AddOP("rezultat");
        }

        public override void init()
        {
            p = new Podaci();
            phase = PHASE1.ceka_podatke; 
        }

        public override double tau()
        {
            switch (phase)
            {
                case PHASE1.ceka_podatke:
                    return double.MaxValue;
                case PHASE1.proverava:
                    return 10;
                case PHASE1.azurira:
                    return 15;
                default:
                    return double.MaxValue;
            }
        }

        public override bool delta_x(PortValue x)
        {
            if (phase == PHASE1.ceka_podatke && x.port == podaciIn)
            {
                p = (Podaci)x.value;
                phase = PHASE1.proverava;
                return true;
            }
            else return false;
        }

        public override void delta_y(ref PortValue y)
        {
            if (phase == PHASE1.proverava)
            {
                if (p.brojKartice != 1111 && p.PIN != 0000) { phase = PHASE1.azurira; y.Set(rezultatOut, true); }
                else { phase = PHASE1.ceka_podatke; y.Set(rezultatOut, false); }
            }
            if (phase == PHASE1.azurira) phase = PHASE1.ceka_podatke;
        }

        public override string Get_s()
        {
            return phase.ToString();
        }
    }
}
