﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DEVSsharp;

namespace bankomat
{
    enum PHASE
{
ceka_karticu,
        ceka_PIN,
        ceka_iznos,
        provera_podataka,
        ceka_rezult_provere,
        izbacuje_novac,
        izbacuje_karticu
}

    class BankomatModel: Atomic
    {
        Podaci p;
        PHASE phase;
        public InputPort karticaIn, pinIn, iznosIn, cancelIn, rezultatIn;
        public OutputPort karticaOut, novacOut, podaciOut;

        public BankomatModel(string name)
            : base(name, TimeUnit.Sec)
        {
            karticaIn = AddIP("kartica");
            pinIn = AddIP("PIN");
            iznosIn = AddIP("Iznos");
            cancelIn = AddIP("cancel");
            rezultatIn = AddIP("Rezultat");

            karticaOut = AddOP("karticaOut");
            novacOut = AddOP("novac");
            podaciOut = AddOP("podaci");

            init();
        }

        public override void init()
        {
           p = new Podaci();

            phase = PHASE.ceka_karticu;
        }

        public override double tau()
        {
            switch (phase)
            {
                case PHASE.ceka_karticu:
                    return double.MaxValue;
                case PHASE.ceka_PIN:
                    return 30;
                case PHASE.ceka_iznos:
                    return 30;
                case PHASE.provera_podataka:
                    return 0;
                case PHASE.ceka_rezult_provere:
                    return 15;
                case PHASE.izbacuje_novac:
                    return 5;
                case PHASE.izbacuje_karticu:
                    return 2;
                default:
                    return double.MaxValue;
            }
        }

        public override bool delta_x(PortValue x)
        {
            if (phase == PHASE.ceka_karticu && x.port == karticaIn) 
            {   
                p.brojKartice = (int)x.value;
                phase = PHASE.ceka_PIN; 
                return true; 
            }
            if (phase == PHASE.ceka_PIN && x.port == pinIn) 
            {   
                phase = PHASE.ceka_iznos; 
                p.PIN = (int)x.value;  
                return true; 
            }
            if (phase == PHASE.ceka_PIN && x.port == cancelIn) { phase = PHASE.izbacuje_karticu; return true; }
            
            if (phase == PHASE.ceka_iznos)
            {
                if (x.port == iznosIn) {  phase = PHASE.provera_podataka; return true; }
                else if (x.port == cancelIn) { phase = PHASE.izbacuje_karticu; return true; }
            }
            if (phase == PHASE.ceka_rezult_provere)
            {
                if (x.port == rezultatIn && (bool)x.value == true) { phase = PHASE.izbacuje_novac; return true; }
                else if (x.port == rezultatIn && (bool)x.value == false) { phase = PHASE.izbacuje_karticu; return true; }
            }

            return false;
        }

        public override string Get_s()
        {
            return phase.ToString();
        }
        public override void delta_y(ref PortValue y)
        {
            if (phase == PHASE.ceka_PIN) phase = PHASE.izbacuje_karticu;
            if (phase == PHASE.ceka_iznos) phase = PHASE.izbacuje_karticu;
            if (phase == PHASE.izbacuje_karticu) { phase = PHASE.ceka_karticu; y.Set(karticaOut); }
            if (phase == PHASE.izbacuje_novac) { phase = PHASE.izbacuje_karticu; y.Set(novacOut); }
            if (phase == PHASE.provera_podataka)
            {
                phase = PHASE.ceka_rezult_provere; 
                y.Set(podaciOut, p);
            }
        }
    }
}
