use airserbia
go
create procedure sp_naplata
as
begin
	declare @idRezervacije int, @idKlijenta int, @cena decimal(10,4)

	declare kursor_neplaceni cursor for
	select r.id, r.idKlijenta, s.cena
	from rezervacije r join sedista s
	on r.idSedista=s.id
	where placeno='ne'

	open kursor_neplaceni

	fetch next from kursor_neplaceni
	into @idRezervacije, @idKlijenta, @cena

	while @@FETCH_STATUS = 0
	begin
		declare @iznos decimal(10,4)
		select @iznos=iznos 
		from klijenti
		where id=@idKlijenta

		if @iznos<@cena
		begin
			delete from rezervacije
			where id=@idRezervacije
		end
		else
		begin
			update rezervacije
			set placeno='da'
			where id=@idRezervacije

			update klijenti
			set iznos=iznos-@cena
			where id=@idKlijenta
		end

		fetch next from kursor_neplaceni
		into @idRezervacije, @idKlijenta, @cena
	end

	close kursor_neplaceni
	deallocate kursor_neplaceni
end