use airserbia
go
create procedure sp_naplata
as
begin
	begin try
	
	set deadlock_priority high
	set transaction isolation level
	repeatable read
	
	begin tran
	declare @idRezervacije int, @idKlijenta int, @cena decimal(10,4), @br int
	set @br=0
	save tran sp

	declare kursor_neplaceni cursor for
	select r.id, r.idKlijenta, s.cena
	from rezervacije r join sedista s
	on r.idSedista=s.id
	where placeno='ne'

	open kursor_neplaceni

	fetch next from kursor_neplaceni
	into @idRezervacije, @idKlijenta, @cena

	while @@FETCH_STATUS = 0
	begin
		
		declare @iznos decimal(10,4)
		select @iznos=iznos 
		from klijenti
		where id=@idKlijenta

		if @iznos<@cena
		begin
			delete from rezervacije
			where id=@idRezervacije
		end
		else
		begin
			update rezervacije
			set placeno='da'
			where id=@idRezervacije

			update klijenti
			set iznos=iznos-@cena
			where id=@idKlijenta
		end

		set @br=@br+1
		if @br%5=0
		begin
			save tran sp
		end

		fetch next from kursor_neplaceni
		into @idRezervacije, @idKlijenta, @cena
	end
	end try
	begin catch
		print 'Naplata nije uspela, pokusajte ponovo'
		print error_message()
		rollback tran sp
	end catch

	close kursor_neplaceni
	deallocate kursor_neplaceni
	commit tran
end

-- mora repeatable read
-- ako pokupimo neplacene rezervacije
-- a neko u medjuvremenu otkaze rezervaciju
-- ta rezervacija se brise, ne mozemo da je update-ujemo
-- ali cemo zato da skinemo pare sa racuna