use airserbia
go

create procedure sp_rezervisi
(
	@idKlijenta int,
	@idLeta int,
	@brSedista int
)
as
begin
	begin try
	
	set transaction isolation level serializable
	
	begin tran
	declare @idSedista int

	select @idSedista=id
	from sedista
	where idLeta=@idLeta and brSedista=@brSedista
	
	declare @rezervisano int
	select @rezervisano=count(*)
	from rezervacije
	where idSedista=@idSedista
	
	if @rezervisano=0
	begin
		insert into rezervacije(idKlijenta,idSedista)
		values (@idKlijenta, @idSedista)
	end
	else
	begin
		print 'Sediste je zauzeto! Odaberite drugo sediste.'
	end
	
	commit tran
	end try
	begin catch
		print 'Rezervacija neuspesna, pokusajte ponovo'
		print error_message()
		print error_line()
		rollback tran
	end catch
end


--serializable

--ako stavimo repeatable read
--transakcija t1, klijent 8 rezervise sediste 2 na letu 1
--transakcija t2, klijent 6 rezervise sediste 2 na letu 1
--i klijent 8 i klijent 6 prvo select-om vide da je sediste slobodno
--onda i jedan i drugi urade rezervaciju tog sedista

--sa serializable
--ne moze da se ubaci nova rezervacija tamo gde je prethodno select-ovano
--ako obe select-uju pre insert-a, dolazi do deadlock-a
--jedna izlazi kao pobednik i uzima sediste
