use airserbia
go
create procedure sp_otkazi
(
	@idRezervacije int
)
as
begin
	begin try
	
	set transaction isolation level
	repeatable read
	
	begin tran
	declare @placeno varchar(10)
	select @placeno=placeno
	from rezervacije
	where id=@idRezervacije

	

	if @placeno is null
	begin
		print 'Rezervacija ne postoji.'
	end

	else if @placeno='da'
	begin
		print 'Ne mozete otkazati rezervaciju.'
	end

	else
	begin
		delete from rezervacije
		where id=@idRezervacije
		print 'Uspesno otkazana rezervacija.'
	end
	commit tran
	end try
	begin catch
		print 'Otkazivanje nije uspelo, pokusajte ponovo'
		print error_message()
		rollback tran
	end catch
end

-- mora repeatable read
-- ako selectujemo da nesto nije placeno
-- to ne sme da se promeni

-- ako stavimo read committed
-- moze da se desi da procitamo da nije placeno
-- da sp_naplata u medjuvremenu skine pare sa naseg racuna
-- a da mi onda otkazemo
-- i izbrisemo rezervaciju
-- a pare se ne vrate

-- sa repeatable read moze doci do deadlock-a