/*
 * Na ulazu se daje broj Web strana (n) i broj
 * njihovih povezanosti linkovima (l, orijentisano).
 * Zatim se daju povezanosti, pocetna strana i
 * maksimalna dozvoljena dubina.
 * Odrediti strane cija je dubina veca od dozvoljene.
*/

#include <stdio.h>
#include <stdlib.h>

#define POVEZANO 1
#define NEPOVEZANO 0
#define NEDEFINISANO -1

typedef struct element {
	int cvor;
	struct element *sledeci;
} Element;

//dodavanje na red
void dodaj(Element **pocetak, Element **kraj, int u)
{
	Element *novi;
	novi = (Element *)malloc(sizeof(Element));
	novi->cvor = u;
	novi->sledeci = NULL;
	
	if (*pocetak==NULL) {
		*pocetak=*kraj=novi;
	}
	else {
		(*kraj)->sledeci = novi;
		*kraj = novi;
	}
}

//skidanje sa reda
int skini(Element **pocetak, Element **kraj)
{
	Element *temp;
	int u;
	
	if (*pocetak==NULL) {
		return NEDEFINISANO;
	}
	else {
		temp = *pocetak;
		*pocetak = temp->sledeci;
		if (*kraj==temp)
			*kraj=NULL;
		u = temp->cvor;
		free(temp);
		return u;
	}
}

void stampajPut(int *pret, int s, int v) {
	if (v==s)
		printf("%d ", s);
	else if (pret[v]==NEDEFINISANO)
		printf("Nema puta od %d do %d.\n",v, s);
	else {
		stampajPut(pret, s, pret[v]);
		printf("%d ", v);
	}
}



main() {
	int **graf, *d, *pret;
	int n, l, s, maxDubina;
	int u, v;
	int i, j;
	
	Element *pocetak, *kraj;
	
	//Uneti broj cvorova i veza
	scanf("%d%d", &n, &l);
	
	//Alocirati matricu povezanosti
	graf = (int **)malloc(n*sizeof(int *));
	for (i=0; i<n; i++)
		graf[i] = (int *)malloc(n*sizeof(int));
	
	//Alocirati niz rastojanja i prethodnika
	d = (int *)malloc(n*sizeof(int));
	pret = (int *)malloc(n*sizeof(int));
	
	//Inicijalizovati matricu povezanosti
	for (i=0; i<n; i++)
		for (j=0; j<n; j++) {
			graf[i][j] = NEPOVEZANO;
		}
	
	//Uneti veze
	for (i=0; i<l; i++) {
		scanf("%d%d", &u, &v);
		graf[u][v] = POVEZANO;
		// Za neorijentisan graf
		// graf[v][u] = POVEZANO;
	}
	
	//Uneti pocetni cvor i maksimalnu dubinu
	scanf("%d%d", &s, &maxDubina);
	
	//Inicijalizacija
	for (i=0; i<n; i++) {
		d[i] = NEDEFINISANO;
		pret[i] = NEDEFINISANO;
	}
	
	d[s]=0;
	pocetak=kraj=NULL;
	
	dodaj(&pocetak, &kraj, s);
	
	//Pretraga
	while((u=skini(&pocetak, &kraj)) != NEDEFINISANO)
	{
		for (v=0; v<n; v++) {
			if (graf[u][v]==POVEZANO) {
				if (d[v]==NEDEFINISANO) {
					d[v]=d[u]+1;
					pret[v]=u;
					dodaj(&pocetak, &kraj, v);
				}
			}
		}
	}
	
	printf("Stranice koje ne ispunjavaju uslov:\n");
	for (u=0; u<n; u++)
		if (d[u]>maxDubina || d[u]==NEDEFINISANO) {
			printf("%d\n", u);
			printf("Put do cvora:\n");
			stampajPut(pret, s, u);
			printf("\n");
		}
	printf("\n");
	
	

}













